//$Id: menu-res.h,v 1.3 2001/02/25 19:10:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_MENU_RES_H
#define GUIKATCHU_MENU_RES_H

namespace Guikachu
{
    namespace Resources
    {
	struct MenuItem;
	struct Submenu;
	class Menu;
    }
}

#include "resource.h"
#include "menu-win.h"

#include <vector>

namespace Guikachu
{
    namespace Resources
    {
	struct MenuItem
	{
	    bool separator;
	    string id;
	    string label;
	    char shortcut;
	};

	struct Submenu
	{
	    string label;
	    vector<MenuItem> items;
	    Submenu () {};
	    Submenu (const string& label_): label (label_) {};
	};
	
	class Menu: public Resource
	{
	    Guikachu::GUI::MenuWindow *gui;
	    vector<Submenu> submenus;
	public:
	    Menu (const string& id);
	    virtual ~Menu ();
	    
	    virtual Type get_type () const { return RESOURCE_MENU; };
	    virtual void show_ui ();

	    vector<Submenu> get_submenus () const { return submenus; };
	    void set_submenus (const vector<Submenu>& submenus);
	    
	private:
	    virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    virtual void save (xmlNodePtr node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    };
};

#endif /* !GUIKATCHU_DIALOGRES_H */
