//$Id: widget.h,v 1.15 2001/05/11 16:37:08 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_WIDGET_H
#define GUIKACHU_FORM_EDITOR_WIDGET_H

namespace Guikachu
{
    namespace Widgets
    {
	enum Type
	{
	    WIDGET_LABEL,
	    WIDGET_BUTTON,
	    WIDGET_PUSHBUTTON,
	    WIDGET_GRAFFITI,
	    WIDGET_SELECTOR_TRIGGER,
	    WIDGET_CHECKBOX,
	    WIDGET_LIST
	};

	class Widget;
    }
}

#include <string>
#include <iostream>
#include <gnome-xml/tree.h>
#include <sigc++/basic_signal.h>

#include "form-res.h"
#include "form.h"
#include "canvasitem.h"

namespace Guikachu
{
    
    namespace Widgets
    {
	class Widget: public SigC::Object
	{
	protected:
	    string id;
	    Resources::Form *owner;
	public:
	    virtual ~Widget () {};
	    
	    virtual Type get_type () const = 0;
	    
	    // Resource managment functions
	    string get_id ();
	    void   set_id (const string& id);
	    
	    SigC::Signal0<void> changed;

	    // Common properties
	    GUIKACHU_RESOURCE_PROP (x, int);
	    GUIKACHU_RESOURCE_PROP (y, int);

	    // Preview-related methods
	    virtual GUI::FormEditor::CanvasItem *get_canvas_item(GUI::FormEditor::Form *form) = 0;
	    virtual Gtk::Widget *get_editor () = 0;

	    Resources::Form *get_form () { return owner; };

	    SigC::Signal0<void> show_editor;
	    
	private:
	    // Persistance
	    virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node) = 0;
	    virtual void save (xmlNodePtr node) const = 0;
	    virtual void save_rcp (ostream &ostr) const = 0;
	    friend ostream& operator<< (ostream &ostr, const Widget *res);
	    
	    friend class Resources::Form;
	};
	
	ostream& operator<< (ostream &ostr, const Widget* res);
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_WIDGET_H */
