//$Id: selector-trigger.cc,v 1.3 2001/04/30 20:47:27 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "selector-trigger.h"
#include "selector-trigger-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::SelectorTrigger;
using namespace Guikachu::GUI::FormEditor;

SelectorTrigger::SelectorTrigger (Resources::Form *owner_,
				  const string& id_):
    text (id_),
    font (0),
    usable (true),
    anchor_right (false),
    width (1),
    manual_width (false),
    height (1),
    manual_height (false)
{
    id = id_;
    owner = owner_;

    x = 5;
    y = 20;

    editor = new SelectorTriggerProperties (this);
}

SelectorTrigger::~SelectorTrigger ()
{
    delete editor;
}

Gtk::Widget *SelectorTrigger::get_editor ()
{
    return editor->get_editor ();
}

bool SelectorTrigger::load (xmlDocPtr doc,
		       xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_text_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "width");
	    if (!xml_val)
	    {
		manual_width = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_width = false;
		} else {
		    manual_width = true;
		    width = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "height");
	    if (!xml_val)
	    {
		manual_height = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_height = false;
		} else {
		    manual_height = true;
		    height = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "text") && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	    XML_GET_NUM_PROP (curr_node, "font", font);
		
	    xml_text_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else if (XML_HAS_NAME (curr_node, "anchor_right"))
	{
	    anchor_right = true;
	}
	else
	    g_warning ("Error parsing `button' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void SelectorTrigger::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Frame */
    if (manual_width)
	buffer = g_strdup_printf ("%d", width);
    else
	buffer = g_strdup ("auto");
    xmlSetProp (my_node, (xmlChar*) "width", (xmlChar*) buffer);
    g_free (buffer);

    if (manual_height)
	buffer = g_strdup_printf ("%d", height);
    else
	buffer = g_strdup ("auto");
    xmlSetProp (my_node, (xmlChar*) "height", (xmlChar*) buffer);
    g_free (buffer);

    /* Usable */
    if (usable)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);

    /* Anchor right */
    if (anchor_right)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "anchor_right", NULL);
    
    /* Label and font */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*) text.c_str ());
    buffer = g_strdup_printf ("%d", font);
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);
}

void SelectorTrigger::save_rcp (ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width);
    else
	width_str = g_strdup ("AUTO");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height);
    else
	height_str = g_strdup ("AUTO");

    ostr << "  SELECTORTRIGGER \"" << text << "\" ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    if (anchor_right)
	ostr << " RIGHTANCHOR";
    else
	ostr << " LEFTANCHOR";
    
    ostr << endl;

    g_free (height_str);
    g_free (width_str);
}

CanvasItem* SelectorTrigger::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new SelectorTriggerCanvasItem (this, form);
}
