//$Id: pushbutton-canvas.cc,v 1.4 2001/06/09 13:23:20 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton-canvas.h"

#include "form-editor.h"

#include <gnome--.h>

using namespace Guikachu::GUI::FormEditor;

PushButtonCanvasItem::PushButtonCanvasItem (Widgets::PushButton *widget_,
					    FormEditor::Form    *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void PushButtonCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    int width = widget->get_width ();
    int height = widget->get_height ();
    
    int text_width = get_string_width (widget->get_font (), widget->get_text ());
    int text_height = get_font_height (widget->get_font ());
    
    if (!widget->get_manual_width ())
	width = 2 + text_width + 2;
    if (!widget->get_manual_height ())
	height = text_height + 3;

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->get_x ();
    int x2 = x1 + width + 1;
    int y1 = widget->get_y ();
    int y2 = y1 + height + 1;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    Gnome::CanvasPoints frame_points;
    using namespace Gnome::Art;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    Gnome::CanvasPolygon *frame_item = new Gnome::CanvasPolygon (*group, frame_points);
    frame_item->set_width_units (1);

    if (widget->get_usable ())
	frame_item->set_outline_color (GUIKACHU_FGC);
    else
	frame_item->set_outline_color (GUIKACHU_FGC_DISABLED);
    
    int text_x = widget->get_x () + width / 2;
    int text_y = widget->get_y () + height / 2;

    draw_text (*group,
	       widget->get_text (), widget->get_font (),
	       text_x, text_y,
	       widget->get_usable (),
	       GTK_ANCHOR_CENTER,
	       width, height);
}
