//$Id: list-prop.cc,v 1.2 2001/05/06 21:59:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"
#include "widgets/propertytable.h"
#include "widgets/string-list.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ListProperties::ListProperties (List *res)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::List::get_id),
	slot (res, &Widgets::List::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Font */
    control = new GUI::NumEntry (
	0, 2,
	slot (res, &Widgets::List::get_font),
	slot (res, &Widgets::List::set_font),
	res->changed);
    proptable->add (_("Font:"), *manage (control));

    /* Number of visible items */
    control = new GUI::NumEntry (
	1, 20,
	slot (res, &Widgets::List::get_visible_items),
	slot (res, &Widgets::List::set_visible_items),
	res->changed);
    proptable->add (_("Visible items:"), *manage (control));

    /* Usable */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::List::get_usable),
	slot (res, &Widgets::List::set_usable),
	res->changed);
    proptable->add (_("Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::List::get_x),
	slot (res, &Widgets::List::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control),
		    _("Horizontal position of the widget, relative "
		      "to the parent form"));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::List::get_y),
	slot (res, &Widgets::List::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control),
		    _("Vertical position of the widget, relative "
		      "to the parent form"));

    /* Width */
    control = new GUI::PosEntry (
	slot (res, &Widgets::List::get_width),
	slot (res, &Widgets::List::set_width),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::List::get_manual_width),
	slot (res, &Widgets::List::set_manual_width),
	res->changed);
    proptable->add (_("Width:"), *manage (control),
		    _("Horizontal size of the widget "
		      "(check to set manually)"));

    /* Items */
    control = new GUI::StringList (
	slot (res, &Widgets::List::get_items),
	slot (res, &Widgets::List::set_items),
	res->changed);
    proptable->add ("foo", *manage (control));
    
    proptable->show_all ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

ListProperties::~ListProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* ListProperties::get_editor ()
{
    return property_editor;
}
