//$Id: list-canvas.cc,v 1.4 2001/06/09 13:23:20 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list-canvas.h"

#include "form-editor.h"

#include <gnome--.h>

using namespace Guikachu::GUI::FormEditor;

ListCanvasItem::ListCanvasItem (Widgets::List    *widget_,
				FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void ListCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    GdkFont *font = get_font (widget->get_font ());

    {
	int height = get_font_height (widget->get_font ()) *
	    widget->get_visible_items ();
	
	int width = widget->get_width ();
	if (!widget->get_manual_width ())
	    width = 18;
	
	int x1 = widget->get_x ();
	int y1 = widget->get_y ();
	int x2 = x1 + width;
	int y2 = y1 + height;

	using namespace Gnome::Art;
	
	Gnome::CanvasPoints frame_points;
	
	frame_points.push_back (Point (x1, y1));
	frame_points.push_back (Point (x2, y1));
	frame_points.push_back (Point (x2, y2));
	frame_points.push_back (Point (x1, y2));
	frame_points.push_back (Point (x1, y1));
    
	Gnome::CanvasPolygon *item = new Gnome::CanvasPolygon (*group, frame_points);
	item->set_width_units (1);
    
	if (widget->get_usable ())
	    item->set_outline_color (GUIKACHU_FGC);
	else
	    item->set_outline_color (GUIKACHU_FGC_DISABLED);
    }
    
    gdk_font_unref (font);
}
