//$Id: form.cc,v 1.11 2001/06/09 13:23:20 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--.h>
#include <sigc++/retbind.h>

#include "form-editor.h"

using namespace Guikachu::GUI::FormEditor;

#define GUIKACHU_WINDOW_TITLE_HEIGHT 14

Form::Form (Resources::Form *res_,
	    GUI::FormWindow *win_):
    res (res_),
    win (win_),
    editor (res),
    canvas (win->get_canvas ()),
    group (0),
    frame_group (0),
    title_group (0),
    widget_group (0)
{
    using namespace SigC;

    Gnome::CanvasRect *background =
	new Gnome::CanvasRect ((*canvas->root ()),
			       0, 0,
			       GUIKACHU_SCREEN_WIDTH, GUIKACHU_SCREEN_HEIGHT);
    background->set_width_pixels (0);
    background->set_fill_color (GUIKACHU_BGC);
    
    group = new Gnome::CanvasGroup (*(canvas->root ()), 0, 0);
    group->event.connect (slot (this, &Form::canvas_event_cb));
    
    res->changed.connect (slot (this, &Form::update));
    update ();
}

Form::~Form ()
{
}

Gnome::CanvasGroup *Form::get_canvas () const
{
    return widget_group;
}

void Form::update ()
{
    draw_frame ();
    draw_title ();
    
    group->set_x (res->get_x ());
    group->set_y (res->get_y ());

    /* Reset canvas group */
    if (widget_group)
	delete widget_group;
    widget_group = new Gnome::CanvasGroup (*group, 0, 0);

    /* This looks like my ass
     * But I can't really find a feasible solution to bind the
     * lifetime of Guikachu::GUI::FormEditor::CanvasItems to
     * the lifetime of their underlying Gnome::CanvasItem.
     */
    static list<CanvasItem*> canvas_item_list;
    for (list<CanvasItem*>::iterator i = canvas_item_list.begin ();
	 i != canvas_item_list.end (); i++)
	delete *i;
    canvas_item_list.clear ();
    
    set<Widgets::Widget*> wset = res->get_widgets ();
    for (set<Widgets::Widget*>::iterator i = wset.begin ();
	 i != wset.end (); i++)
    {
	CanvasItem *canvas_item = (*i)->get_canvas_item (this);
	canvas_item_list.push_back (canvas_item);
    }
}

Gtk::Widget* Form::get_editor ()
{
    return editor.get_editor ();
}

void Form::draw_frame ()
{
    if (frame_group)
	delete frame_group;
    frame_group = new Gnome::CanvasGroup (*group, 0, 0);
    
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->get_width (), res->get_height ());
    frame_rect->set_width_units (1);
    frame_rect->set_fill_color ("");
    
    if (res->get_modal ())
	draw_frame_modal ();
    else
	if (res->get_frame ())
	    draw_frame_nonmodal ();
}

void Form::draw_frame_nonmodal ()
{
    Gnome::CanvasRect *frame_rect =
	new Gnome::CanvasRect (*frame_group,
			       -1, -1,
			       res->get_width (), res->get_height ());
    
    frame_rect->set_width_units (1);
    frame_rect->set_outline_color (GUIKACHU_FGC);
    frame_rect->set_fill_color ("");
}

void Form::draw_frame_modal ()
{
    Gnome::CanvasPoints outer_points, inner_points;

    int x0 = 0;
    int y0 = 0;
    int x1 = res->get_width ();
    int y1 = res->get_height ();
    
    // NW
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 2) ));

    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 1) ));
    
    // NE
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 2) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y0)     ));

    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1),     (y0)     ));

    // SE
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y1 - 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1 + 1) ));

    inner_points.push_back (Gnome::Art::Point ( (x1),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));

    // SW
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y1 + 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y1 - 1) ));
    
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y1 - 1) ));
    
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));

    Gnome::CanvasLine *outer = new Gnome::CanvasLine (*frame_group, outer_points);
    outer->set_width_units (1);
    outer->set_fill_color (GUIKACHU_FGC);

    Gnome::CanvasLine *inner = new Gnome::CanvasLine (*frame_group, inner_points);
    inner->set_width_units (1);
    inner->set_fill_color (GUIKACHU_FGC);
}

void Form::draw_title ()
{
    if (title_group)
	delete title_group;
    title_group = new Gnome::CanvasGroup (*group, 0, 0);

    if (res->get_title () == "")
	return;
    
    if (res->get_modal ())
	draw_title_modal ();
    else
	draw_title_nonmodal ();
}

void Form::draw_title_nonmodal ()
{
    Gnome::CanvasPoints points;
    double title_width;
    GdkFont *gdk_font;
    
    gdk_font = get_title_font ();
    
    title_width = get_string_width (1, res->get_title ()) + 2; /* Title is font#1 */
    title_width = MIN (title_width + 5, res->get_width ());

    int max_width = res->get_width ();
    int max_height = MIN (res->get_height (), GUIKACHU_WINDOW_TITLE_HEIGHT);
    
    // NW corner
    points.push_back (Gnome::Art::Point (0, 1));
    points.push_back (Gnome::Art::Point (1, 0));

    // NE corner
    points.push_back (Gnome::Art::Point (title_width,     0));
    points.push_back (Gnome::Art::Point (title_width + 1, 1));

    // SE corner
    points.push_back (Gnome::Art::Point ((title_width + 1), (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // SW corner
    points.push_back (Gnome::Art::Point (0, (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // Back to NW
    points.push_back (Gnome::Art::Point (0, 1));

    {
	using namespace Gnome::CanvasHelpers;

	*(new Gnome::CanvasPolygon (*title_group, points))
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);
	
	*(new Gnome::CanvasText (*title_group, 1, 0, res->get_title ()))
	    << font (gdk_font)
	    << clip_width (max_width) << clip_height (max_height)
	    << clip (false)
	    << anchor (GTK_ANCHOR_NW)
	    << fill_color (GUIKACHU_BGC);
	
	*(new Gnome::CanvasRect (*title_group))
	    << x1 (0) << y1 (GUIKACHU_WINDOW_TITLE_HEIGHT)
	    << x2 (res->get_width ()) << y2 (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);
    }
    
    gdk_font_unref (gdk_font);
}

void Form::draw_title_modal ()
{
    Gnome::CanvasPoints points;
    GdkFont *gdk_font;
    
    gdk_font = get_title_font ();
    
    double title_height = MIN (res->get_height (), 11);
    double title_center = res->get_width () / 2;

    int max_width = res->get_width ();
    int max_height = MIN (res->get_height (), 11);

    {
	using namespace Gnome::CanvasHelpers;
    
	*(new Gnome::CanvasRect (*title_group))
	    << x1 (0) << y1 (0)
	    << x2 (res->get_width ()) << y2 (title_height)
	    << width_units (1)
	    << fill_color (GUIKACHU_FGC);
	
	*(new Gnome::CanvasText (*title_group, title_center, -1, res->get_title ()))
	    << font (gdk_font)
	    << clip_width (max_width) << clip_height (max_height)
	    << clip (true)
	    << anchor (GTK_ANCHOR_N)
	    << fill_color (GUIKACHU_BGC);
    }

    gdk_font_unref (gdk_font);
}

int Form::canvas_event_cb (GdkEvent *e)
{
    static bool dragging = false;
    static bool drag_occured = false;

    static double last_x, last_y;    
    static double offset_x, offset_y;
    
    if (e->type == GDK_BUTTON_RELEASE &&
	(e->button.button == 1))
    {
	group->ungrab (e->button.time);
	dragging = false;
	
	if (drag_occured)
	{
	    res->set_x (last_x - offset_x);
	    res->set_y (last_y - offset_y);
	}
    }

    if (e->type == GDK_MOTION_NOTIFY && dragging)
    {
	drag_occured = true;

	double curr_x = e->motion.x;
	double curr_y = e->motion.y;

	// Right and lower bounds
	if ((curr_x - offset_x) > (GUIKACHU_SCREEN_WIDTH - 1))
	    curr_x = (GUIKACHU_SCREEN_WIDTH - 1) + offset_x;
	if ((curr_y - offset_y) > (GUIKACHU_SCREEN_HEIGHT - 1))
	    curr_y = (GUIKACHU_SCREEN_HEIGHT - 1) + offset_y;

	// Left and upper bounds
	if ((curr_x - offset_x) < 0)
	    curr_x = offset_x;
	if ((curr_y - offset_y) < 0)
	    curr_y = offset_y;
	
	group->move (curr_x - last_x, curr_y - last_y);
	
	last_x = curr_x;
	last_y = curr_y;
    }

    
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
    {
	dragging = true;
	drag_occured = false;

	last_x = e->button.x;
	last_y = e->button.y;

	offset_x = last_x - res->get_x ();
	offset_y = last_y - res->get_y ();

	Gdk_Cursor cursor (gdk_cursor_new (GDK_FLEUR));
	group->grab (GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		     cursor, e->button.time);
	
	show_editor ();
    }
    
    return true;
}

