//$Id: form-editor.cc,v 1.7 2001/06/09 13:23:20 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-editor.h"

#include <gdk/gdk.h>
#include <gnome--/canvas.h>
#include <gnome--/canvas-text.h>

using namespace Guikachu::GUI;

/* Thanks for the PilRC-UI people for figuring out these approximations */
#define GUIKACHU_FONT0 "-Adobe-Helvetica-Medium-R-Normal--*-80-*-*-*-*-iso8859-1"
#define GUIKACHU_FONT1 "-Adobe-Helvetica-Medium-R-Normal--*-100-*-*-*-*-iso8859-1"
#define GUIKACHU_FONT2 "-Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-iso8859-1"

#define GUIKACHU_TITLE_FONT GUIKACHU_FONT1

GdkFont *FormEditor::get_font (int font_num)
{
    GdkFont *font = 0;

    switch (font_num)
    {
    case 0:
        font = gdk_font_load (GUIKACHU_FONT0);
        break;
    case 1:
        font = gdk_font_load (GUIKACHU_FONT1);
        break;
    case 2:
        font = gdk_font_load (GUIKACHU_FONT2);
        break;
    default:
        g_assert_not_reached ();
        break;
    }

    return font;
}

GdkFont *FormEditor::get_title_font ()
{
    GdkFont *font = gdk_font_load (GUIKACHU_TITLE_FONT);
	
    return font;
}

int FormEditor::get_font_height (int font_num)
{
    switch (font_num)
    {
    case 2:
	return 14;
	break;
    default:
	return 11;
	break;
    }
}

int FormEditor::get_string_width (int font_num, const string& text)
{
    GdkFont *font = get_font (font_num);

    int width = gdk_string_width (font, text.c_str ());
    
    gdk_font_unref (font);

    return width;
}

Gnome::CanvasItem* FormEditor::draw_text (Gnome::CanvasGroup &group,
					  const string &text, int font_num,
					  int x, int y,
					  bool usable = true,
					  GtkAnchorType anchor = GTK_ANCHOR_NW,
					  int clip_width = 0, int clip_height = 0)
{   
    GdkFont *font = get_font (font_num);

    Gnome::CanvasText *item = new Gnome::CanvasText (group, x, y, text);
    item->set_font (font);
    item->set_anchor (anchor);

    if (usable)
        item->set_fill_color (GUIKACHU_FGC);
    else
        item->set_fill_color (GUIKACHU_FGC_DISABLED);

    if (clip_width || clip_height)
    {
	item->set_clip (true);
	item->set_clip_width (clip_width);
	item->set_clip_height (clip_height);
    }

    gdk_font_unref (font);

    return item;
}
