//$Id: num-entry.cc,v 1.1 2001/04/14 18:01:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "num-entry.h"

#include <gtk--/adjustment.h>

using namespace Guikachu::GUI;

NumEntry::NumEntry (int min, int max,
		    SigC::Slot0<int> get_slot,
		    SigC::Slot1<void, const int&> set_slot,
		    SigC::Signal0<void>& changed_sig):
    get_val (get_slot),
    set_val (set_slot),
    update_block (false)
{
    using namespace SigC;
    
    Gtk::Adjustment *adj = new Gtk::Adjustment (min, min, max);
    adj->value_changed.connect (slot (this, &NumEntry::changed_cb));
    set_adjustment (*manage (adj));
    
    set_update_policy (GTK_UPDATE_IF_VALID);
    set_digits (0);

    changed_sig.connect (slot (this, &NumEntry::update));
    update ();
}

void NumEntry::update ()
{
    update_block = true;

    set_value (get_val ());
    
    update_block = false;
}

void NumEntry::changed_cb ()
{
    if (!update_block)
	set_val (get_value_as_int ());
}
