//$Id: widget.cc,v 1.9 2001/04/25 09:46:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget.h"

#include "resource-manager.h"
#include "form-editor.h"

using namespace Guikachu;

string Widgets::Widget::get_id ()
{
    return id;
}

void Widgets::Widget::set_id (const string& new_id)
{
    if (ResourceManager::rename_resource (id, new_id))
	id = new_id;

    changed ();
}

ostream& Widgets::operator<< (ostream &ostr, const Widget* res)
{
    res->save_rcp (ostr);
    return ostr;
}


GUI::FormEditor::CanvasItem::CanvasItem (Widgets::Widget *widget_):
    widget (widget_)
{
}

int GUI::FormEditor::CanvasItem::canvas_event_cb (GdkEvent *e)
{
    static bool dragging = false;
    static bool drag_occured = false;

    static double last_x, last_y;    
    static double offset_x, offset_y;
    
    if (e->type == GDK_BUTTON_RELEASE &&
	(e->button.button == 1))
    {
	item->ungrab (e->button.time);
	dragging = false;
	
	if (drag_occured)
	{
	    widget->set_x (last_x - offset_x);
	    widget->set_y (last_y - offset_y);
	}
    }

    if (e->type == GDK_MOTION_NOTIFY && dragging)
    {
	drag_occured = true;

	double curr_x = e->motion.x;
	double curr_y = e->motion.y;

	// Right and lower bounds
	if ((curr_x - offset_x) > (GUIKACHU_SCREEN_WIDTH - 1))
	    curr_x = (GUIKACHU_SCREEN_WIDTH - 1) + offset_x;
	if ((curr_y - offset_y) > (GUIKACHU_SCREEN_HEIGHT - 1))
	    curr_y = (GUIKACHU_SCREEN_HEIGHT - 1) + offset_y;

	// Left and upper bounds
	if ((curr_x - offset_x) < 0)
	    curr_x = offset_x;
	if ((curr_y - offset_y) < 0)
	    curr_y = offset_y;
	
	item->move (curr_x - last_x, curr_y - last_y);
	
	last_x = curr_x;
	last_y = curr_y;
    }

    
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
    {
	dragging = true;
	drag_occured = false;

	last_x = e->button.x;
	last_y = e->button.y;

	offset_x = last_x - widget->get_x ();
	offset_y = last_y - widget->get_y ();

	Gdk_Cursor cursor (gdk_cursor_new (GDK_FLEUR));
	item->grab (GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		    cursor, e->button.time);
	
	widget->show_editor ();
    }
    
    return true;
}

void GUI::FormEditor::CanvasItem::set_canvas_item (Gnome::CanvasItem *item_)
{
    item = item_;

    item->event.connect (SigC::slot (this, &CanvasItem::canvas_event_cb));
}
