//$Id: label-canvas.cc,v 1.1 2001/04/30 20:47:27 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label-canvas.h"

#include "form-editor.h"

#include <gnome--.h>

using namespace Guikachu::GUI::FormEditor;

LabelCanvasItem::LabelCanvasItem (Widgets::Label   *widget_,
				  FormEditor::Form *form_):
    CanvasItem (widget_),
    widget (widget_),
    form (form_),
    group (0)
{
    using namespace SigC;

    widget->changed.connect (slot (this, &LabelCanvasItem::update));
    update ();
}

void LabelCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    GdkFont *font = get_font (widget->get_font ());
    
    Gnome::CanvasText *item = new Gnome::CanvasText (*group,
                                                     "text", widget->get_text ().c_str (),
                                                     "font_gdk", font,
                                                     "x", (float)widget->get_x (),
                                                     "y", (float)widget->get_y (),
                                                     "anchor", GTK_ANCHOR_NW,
                                                     0);
    if (widget->get_usable ())
        item->set_fill_color (GUIKACHU_FGC);
    else
        item->set_fill_color (GUIKACHU_FGC_DISABLED);
    
    gdk_font_unref (font);
}
