//$Id: form-prop.cc,v 1.7 2001/04/14 18:01:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/widget-combo.h"
#include "widgets/resource-combo.h"
#include "widgets/propertytable.h"


using namespace Guikachu::GUI::FormEditor;

FormProperties::FormProperties (Resources::Form *res_):
    res (res_)
{
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Resources::Resource::get_id),
	slot (res, &Resources::Resource::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Title */
    control = new GUI::Entry (
	true,
	slot (res, &Resources::Form::get_title),
	slot (res, &Resources::Form::set_title),
	res->changed);
    proptable->add (_("Title:"), *manage (control));

    /* Help ID */
    control = new GUI::ResourceCombo (
	Resources::RESOURCE_STRING,
	slot (res, &Resources::Form::get_help_id),
	slot (res, &Resources::Form::set_help_id),
	res->changed);
    proptable->add (_("Help ID:"), *manage (control));
    
    /* Menu ID */
    control = new GUI::ResourceCombo (
	Resources::RESOURCE_MENU,
	slot (res, &Resources::Form::get_menu_id),
	slot (res, &Resources::Form::set_menu_id),
	res->changed);
    proptable->add (_("Menu ID:"), *manage (control));
    
    /* Modal */
    control = new GUI::ToggleButton (
	slot (res, &Resources::Form::get_modal),
	slot (res, &Resources::Form::set_modal),
	res->changed);
    proptable->add (_("Modal:"), *manage (control));

    /* Frame */
    control = new GUI::ToggleButton (
	slot (res, &Resources::Form::get_frame),
	slot (res, &Resources::Form::set_frame),
	res->changed);
    proptable->add (_("Frame:"), *manage (control));

    /* Save behind */
    control = new GUI::ToggleButton (
	slot (res, &Resources::Form::get_savebehind),
	slot (res, &Resources::Form::set_savebehind),
	res->changed);
    proptable->add (_("Save behind:"), *manage (control));

    /* Default button */
    control = new GUI::WidgetCombo (
	res,
	Widgets::WIDGET_BUTTON,
	slot (res, &Resources::Form::get_def_button),
	slot (res, &Resources::Form::set_def_button),
	res->changed);
    proptable->add (_("Default button:"), *manage (control));
    
    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Resources::Form::get_x),
	slot (res, &Resources::Form::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Resources::Form::get_y),
	slot (res, &Resources::Form::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control));

    /* Width */
    control = new GUI::PosEntry (
	slot (res, &Resources::Form::get_width),
	slot (res, &Resources::Form::set_width),
	res->changed);
    proptable->add (_("Width:"), *manage (control));

    /* Height */
    control = new GUI::PosEntry (
	slot (res, &Resources::Form::get_height),
	slot (res, &Resources::Form::set_height),
	res->changed);
    proptable->add (_("Height:"), *manage (control));
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

FormProperties::~FormProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* FormProperties::get_editor ()
{
    return property_editor;
}
