//$Id: form-editor.cc,v 1.5 2001/04/28 16:26:30 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-editor.h"
#include <gdk/gdk.h>

using namespace Guikachu::GUI;

/* Thanks for the PilRC-UI people for figuring out these approximations */
#define GUIKACHU_FONT0 "-Adobe-Helvetica-Medium-R-Normal--*-80-*-*-*-*-iso8859-1"
#define GUIKACHU_FONT1 "-Adobe-Helvetica-Medium-R-Normal--*-100-*-*-*-*-iso8859-1"
#define GUIKACHU_FONT2 "-Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-iso8859-1"

#define GUIKACHU_TITLE_FONT GUIKACHU_FONT1

GdkFont *FormEditor::get_font (int font_num)
{
    GdkFont *font = 0;

    switch (font_num)
    {
    case 0:
        font = gdk_font_load (GUIKACHU_FONT0);
        break;
    case 1:
        font = gdk_font_load (GUIKACHU_FONT1);
        break;
    case 2:
        font = gdk_font_load (GUIKACHU_FONT2);
        break;
    default:
        g_assert_not_reached ();
        break;
    }

    return font;
}

GdkFont *FormEditor::get_title_font ()
{
    GdkFont *font = gdk_font_load (GUIKACHU_TITLE_FONT);
	
    return font;
}

int FormEditor::get_font_height (int font_num)
{
    switch (font_num)
    {
    case 2:
	return 14;
	break;
    default:
	return 11;
	break;
    }
}
