//$Id: checkbox-canvas.cc,v 1.3 2001/05/02 14:01:35 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "checkbox-canvas.h"

#include "form-editor.h"

#include <gnome--.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/checkbox-canvas-on.xpm"
#include "pixmaps/checkbox-canvas-on-disabled.xpm"
#include "pixmaps/checkbox-canvas-off.xpm"
#include "pixmaps/checkbox-canvas-off-disabled.xpm"

using namespace Guikachu::GUI::FormEditor;

CheckboxCanvasItem::CheckboxCanvasItem (Widgets::Checkbox *widget_,
					FormEditor::Form    *form_):
    CanvasItem (widget_),
    widget (widget_),
    form (form_),
    group (0)
{
    using namespace SigC;
    
    widget->changed.connect (slot (this, &CheckboxCanvasItem::update));
    update ();
}

void CheckboxCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    GdkFont *font = get_font (widget->get_font ());
    
    int width = widget->get_width ();
    int height = widget->get_height ();
    
    int text_width = gdk_string_width (font, widget->get_text ().c_str ());
    int text_height = get_font_height (widget->get_font ());
    
    if (!widget->get_manual_width ())
	width = 18 + text_width;
    if (!widget->get_manual_height ())
	height = text_height + 3;

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->get_x ();
    int x2 = x1 + width + 1;
    int y1 = widget->get_y ();
    int y2 = y1 + height + 1;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    Gnome::CanvasPoints frame_points;
    using namespace Gnome::Art;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    new Gnome::CanvasPolygon (*group,
			      "points", frame_points.gtkobj (),
			      "width_units", 0.0,
			      0);
    
    int text_x = widget->get_x () + 18;
    int text_y = widget->get_y () + height / 2;

    GdkPixbuf *pixbuf;
    if (widget->get_toggled ())
	if (widget->get_usable ())
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_on_xpm);
	else
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_on_disabled_xpm);
    else
	if (widget->get_usable ())
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_off_xpm);
	else
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_off_disabled_xpm);

    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", pixbuf,
			   "x", (double)widget->get_x () + 3,
			   "y", (double)widget->get_y () + 3,
			   0);
    gdk_pixbuf_unref (pixbuf);
    
    Gnome::CanvasText *text_item = new Gnome::CanvasText (
	*group,
	"text", widget->get_text ().c_str (),
	"font_gdk", font,
	"x", (double) text_x,
	"y", (double) text_y,
	"clip_width", (double) width - 18,
	"clip_height", (double) height,
	"clip", TRUE,
	"anchor", GTK_ANCHOR_WEST,
	0);    
    gdk_font_unref (font);
    
    if (widget->get_usable ())
	text_item->set_fill_color (GUIKACHU_FGC);
    else
	text_item->set_fill_color (GUIKACHU_FGC_DISABLED);
}
