//$Id: dialog-res.cc,v 1.7 2001/04/10 16:17:28 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "dialog-res.h"

#include <gnome-xml/xmlmemory.h>

using namespace Guikachu;

Resources::Dialog::Dialog (const string& id_):
    dialog_type (DIALOG_INFORMATION)
{
    id = id_;
    gui = new GUI::DialogWindow (this);
    default_button = 0;
}

Resources::Dialog::~Dialog ()
{
    delete gui;
}

void Resources::Dialog::show_ui ()
{
    gui->show ();
}

bool Resources::Dialog::load (xmlDocPtr doc,
			      xmlNodePtr node)
{
    xmlNodePtr curr_node;
    bool xml_text_set    = false;
    bool xml_title_set   = false;
    bool xml_help_set    = false;
    bool xml_type_set    = false;
    bool xml_buttons_set = false;

    gchar *xml_val = 0;

#define XML_HAS_NAME(node,val) (!strcmp ((char*)node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}                     \
	
#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr)
    
    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "text")       && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	}
	else if (XML_HAS_NAME (curr_node, "title") && !xml_title_set)
	{
	    XML_GET_CONTENT (curr_node, title);
	}
	else if (XML_HAS_NAME (curr_node, "help")  && !xml_help_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"id");
	    XML_APPLY (help_id);
	}
	else if (XML_HAS_NAME (curr_node, "type")  && !xml_type_set)
	{
	    gchar *xml_type = (gchar*)xmlGetProp (curr_node, (xmlChar*)"value");
	    xml_type_set = true;

	    if (!strcasecmp (xml_type, "information"))
		dialog_type = DIALOG_INFORMATION;
	    else if (!strcasecmp (xml_type, "confirmation"))
		dialog_type = DIALOG_CONFIRMATION;
	    else if (!strcasecmp (xml_type, "warning"))
		dialog_type = DIALOG_WARNING;
	    else if (!strcasecmp (xml_type, "error"))
		dialog_type = DIALOG_ERROR;
	    else
		xml_type_set = false;
	    
	    xmlFree (xml_type);
	}
	else if (XML_HAS_NAME (curr_node, "buttons") && !xml_buttons_set)
	{
	    /* Set default button */
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"default");

	    if (xml_val)
	    {
		default_button = atoi (xml_val);
		xmlFree (xml_val);
	    }
	    
	    /* Iterate buttons */
	    xmlNodePtr button_node;
	    
	    for (button_node = curr_node->xmlChildrenNode;
		 button_node != NULL;
		 button_node = button_node->next)
	    {
		if (XML_HAS_NAME (button_node, "button"))
		{
		    xml_val = (char*)xmlGetProp (button_node, (xmlChar*)"label");
		    
		    if (xml_val)
		    {
			buttons.push_back (xml_val);
			xmlFree (xml_val);
		    }
		} else {
		    g_warning ("Error parsing `dialog' resource: "
			       "unexpected element `%s/%s'",
			       curr_node->name, button_node->name);
		}
	    }
	}
	    
	else
	    g_warning ("Error parsing `dialog' resource: "
		       "unexpected element `%s'", curr_node->name);

    }

    changed ();
    
    return true;
}

void Resources::Dialog::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *xml_type = 0;

    /* Dialog type */
    switch (dialog_type)
    {
    case DIALOG_INFORMATION:
	xml_type = "information";
	break;
    case DIALOG_CONFIRMATION:
	xml_type = "confirmation";
	break;
    case DIALOG_WARNING:
	xml_type = "warning";
	break;
    case DIALOG_ERROR:
	xml_type = "error";
    }

    my_node = xmlNewChild (node, NULL, (xmlChar*) "type", NULL);
    xmlSetProp (my_node, (xmlChar*)"value", (xmlChar*)xml_type);    

    /* Title */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "title",
			   (xmlChar*)title.c_str ());
    /* Text */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*)text.c_str ());

    /* Help ID */
    if (help_id != "")
    {
	my_node = xmlNewChild (node, NULL, (xmlChar*) "help", NULL);
	xmlSetProp (my_node, (xmlChar*) "id", (xmlChar*)help_id.c_str ());    
    }

    /* Buttons */
    if (buttons.size ())
    {
	my_node = xmlNewChild (node, NULL, (xmlChar*) "buttons", NULL);

	gchar *default_button_str = g_strdup_printf ("%d", default_button);
	xmlSetProp (my_node, (xmlChar*) "default", (xmlChar*) default_button_str);
	g_free (default_button_str);
	
	xmlNodePtr button_node;

	for (vector <string>::const_iterator i = buttons.begin ();
	     i != buttons.end (); i++)
	{
	    button_node = xmlNewChild (my_node, NULL, (xmlChar*) "button", NULL);
	    xmlSetProp (button_node, (xmlChar*) "label",
			(xmlChar*) i->c_str ());
	}
    }
}

void Resources::Dialog::save_rcp (ostream &ostr) const
{
    ostr << "ALERT ID " << id << endl;
    
    switch (dialog_type)
    {
    case DIALOG_INFORMATION:
	ostr << "INFORMATION" << endl;
	break;
    case DIALOG_CONFIRMATION:
	ostr << "CONFIRMATION" << endl;
	break;
    case DIALOG_WARNING:
	ostr << "WARNING" << endl;
	break;
    case DIALOG_ERROR:
	ostr << "ERROR" << endl;
	break;
    }
    
    if (help_id != "")
	ostr << "  HELPID " << help_id << endl;

    ostr << "BEGIN" << endl;

    ostr << "  TITLE \"" << title << "\"" << endl
	 << "  MESSAGE \"" << text << "\"" << endl;
    if (buttons.size ())
    {
	ostr << "  BUTTONS ";

	for (vector <string>::const_iterator i = buttons.begin ();
	     i !=  buttons.end (); i++)
	    ostr << "\"" << *i << "\"";
	
	ostr << endl;
    }
    
    ostr << "END" << endl
	 << endl;
}
