//$Id: propertytable.cc,v 1.1 2001/04/14 18:01:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "propertytable.h"

#include <gtk--/separator.h>
#include <gtk--/label.h>

using namespace Guikachu::GUI;

PropertyTable::PropertyTable ():
    curr_row (0)
{
    set_border_width (5);
    set_row_spacings (5);
    set_col_spacings (5);
}

void PropertyTable::add (const string& label,
			 Gtk::Widget& control)
{
    Gtk::Label *label_widget = new Gtk::Label (label, 1, 0.5);

    label_widget->show ();
    control.show ();
    
    attach (*manage (label_widget),
	    0, 1,
	    curr_row, curr_row + 1,
	    GTK_FILL, GTK_FILL);
    attach (control,
	    1, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL, GTK_FILL);

    curr_row++;
}

void PropertyTable::add_separator ()
{
    Gtk::HSeparator *separator = new Gtk::HSeparator ();

    separator->show ();

    attach (*manage (separator),
	    0, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL, GTK_FILL);

    curr_row++;
}
