//$Id: main.cc,v 1.5 2001/04/01 18:16:03 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"

#include <gnome--/main.h>
#include <glade/glade.h>
#include <fcntl.h>

#include "mainwin.h"
#include "resource-manager.h"

namespace Guikachu
{
    enum FileType
    {
	FILETYPE_REGULAR,
	FILETYPE_GLADE
    };

    struct FileEntry
    {
	const char *filename;
	FileType type;
    };
}

using namespace Guikachu;

static bool check_file (FileEntry& file)
{
    bool success = true;
    
    switch (file.type)
    {
    case FILETYPE_REGULAR:
	if (open (file.filename, 0) == -1)
	    success = false;
	break;
    case FILETYPE_GLADE:
	GladeXML *gui = glade_xml_new (file.filename, 0);
	if (!gui)
	    success = false;
	else
	    gtk_object_unref (GTK_OBJECT (gui));
	break;
    }

    return success;
}

static bool check_files ()
{
    bool success = true;
    
    FileEntry files[] = {{GLADEDIR "/guikachu.glade", FILETYPE_GLADE}};    

    for (unsigned int i = 0;
	 i < (sizeof (files) / sizeof (FileEntry*) - 1);
	 i++)
    {
	if (!check_file (files[i]))
	{
	    success = false;
	    gchar *buffer = g_strdup_printf (
		_("Opening file `%s' (required by Guikachu) failed.\n"
		  "Check your Guikachu installation"),
		g_basename (files[i].filename));
	    
	    GUI::show_error (buffer);
	    g_free (buffer);
	}
    }

    return success;
}

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, GNOMELOCALEDIR);
    textdomain (PACKAGE);
#endif

    poptContext ctx;
    Gnome::Main m (PACKAGE, VERSION, argc, argv, NULL, 0, &ctx);
    glade_gnome_init ();

    if (!check_files ())
	return -1;

    ResourceManager::reset ();
    GUI::MainWin w;

    const char **args = poptGetArgs (ctx);
    string filename;
    if (args)
    {
	for (; *args; args++)
	    filename = *args;
	
	ResourceManager::load (filename);
	w.set_filename (filename);
    }
    poptFreeContext (ctx);
    
    w.show_all ();
    m.run ();
}
