//$Id: widget.cc,v 1.7 2001/04/22 14:53:33 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "widget.h"
#include "resource-manager.h"

using namespace Guikachu;

string Widgets::Widget::get_id ()
{
    return id;
};

void Widgets::Widget::set_id (const string& new_id)
{
    if (ResourceManager::rename_resource (id, new_id))
	id = new_id;

    changed ();
};

ostream& Widgets::operator<< (ostream &ostr, const Widget* res)
{
    res->save_rcp (ostr);
    return ostr;
}

GUI::FormEditor::CanvasItem::CanvasItem (Widgets::Widget *widget_):
    widget (widget_)
{
}

int GUI::FormEditor::CanvasItem::canvas_event_cb (GdkEvent *e)
{
    static bool dragging = false;
    static bool drag_occured = false;
    static double x_orig, y_orig;
    
    double x = e->button.x;
    double y = e->button.y;

    static double x_drag, y_drag;

    item->w2i (x, y);

#if 0
    if (e->type == GDK_BUTTON_RELEASE &&
	e->button.button == 1)
    {
	if (drag_occured)
	{
	    int new_x = (int)(x_drag - x_orig) + widget->get_x ();
	    int new_y = (int)(y_drag - y_orig) + widget->get_y ();
	    
	    //widget->set_x (new_x);
	    //widget->set_y (new_y);
	    cout << new_x << "," << new_y << endl;
	}
	
	dragging = false;
	drag_occured = false;
    }
#endif

    if (e->type == GDK_MOTION_NOTIFY && dragging)
    {
	drag_occured = true;
	
	item->move (x - x_orig, y - y_orig);

	x_drag = e->motion.x;
	y_drag = e->motion.y;
    }

    
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
    {
	x_orig = x;
	y_orig = y;
	dragging = true;

	widget->show_editor ();
    }
    
    return true;
}

void GUI::FormEditor::CanvasItem::set_canvas_item (Gnome::CanvasItem *item_)
{
    item = item_;

    item->event.connect (SigC::slot (this, &CanvasItem::canvas_event_cb));
}
