//$Id: label.cc,v 1.13 2001/04/22 14:53:33 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "form-editor.h"

#include <gnome--.h>
#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Label;
using namespace Guikachu::GUI::FormEditor;

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class LabelCanvasItem: public CanvasItem
	    {
		Widgets::Label     *widget;
		FormEditor::Form   *form;
		Gnome::CanvasGroup *group;
	    public:
		LabelCanvasItem (Widgets::Label   *widget,
				 FormEditor::Form *form);
	    private:
		void update ();
	    };
	}
    }
}

Label::Label (Resources::Form *owner_,
	      const string& id_):
    text (id_),
    font (0),
    usable (true)
{
    id = id_;
    owner = owner_;

    x = 5;
    y = 20;

    editor = new LabelProperties (this);
}

Label::~Label ()
{
    delete editor;
}

Gtk::Widget *Label::get_editor ()
{
    return editor->get_editor ();
}

bool Label::load (xmlDocPtr doc,
		  xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_text_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "text") && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	    XML_GET_NUM_PROP (curr_node, "font", font);

	    xml_text_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else
	    g_warning ("Error parsing `label' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void Label::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Usable */
    if (usable)
	xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);
    
    /* Text and font */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*) text.c_str ());
    buffer = g_strdup_printf ("%d", font);
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);
}

void Label::save_rcp (ostream &ostr) const
{
    ostr << "  LABEL \"" << text << "\"" << " ID " << id;
    ostr << " AT (" << x << " " << y << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    ostr << endl;
}

LabelCanvasItem::LabelCanvasItem (Widgets::Label   *widget_,
				  FormEditor::Form *form_):
    CanvasItem (widget_),
    widget (widget_),
    form (form_),
    group (0)
{
    using namespace SigC;
    
    widget->changed.connect (slot (this, &LabelCanvasItem::update));
    update ();
}

void LabelCanvasItem::update ()
{
    if (group)
	delete group;
    form->get_canvas ()->get_canvas ()->update_now ();
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    GdkFont *font = get_font (widget->get_font ());
    
    Gnome::CanvasText *item = new Gnome::CanvasText (*group,
                                                     "text", widget->get_text ().c_str (),
                                                     "font_gdk", font,
                                                     "x", (float)widget->get_x (),
                                                     "y", (float)widget->get_y (),
                                                     "anchor", GTK_ANCHOR_NW,
                                                     0);
    if (widget->get_usable ())
        item->set_fill_color (GUIKACHU_FGC);
    else
        item->set_fill_color (GUIKACHU_FGC_DISABLED);
    
    gdk_font_unref (font);
}

CanvasItem* Label::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new LabelCanvasItem (this, form);
}
