//$Id: graffiti.cc,v 1.2 2001/04/22 13:03:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "form-editor.h"

#include <gnome--.h>
#include <gnome-xml/xmlmemory.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/graffiti-canvas.xpm"

using Guikachu::Widgets::Graffiti;
using namespace Guikachu::GUI::FormEditor;

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class GraffitiCanvasItem: public CanvasItem
	    {
		Widgets::Graffiti  *widget;
		FormEditor::Form   *form;
		Gnome::CanvasGroup *group;
	    public:
		GraffitiCanvasItem (Widgets::Graffiti *res,
				    FormEditor::Form  *form);
	    private:
		void update ();
	    };
	}
    }
}

Graffiti::Graffiti (Resources::Form *owner_,
		    const string& id_)
{
    id = id_;
    owner = owner_;

    x = 5;
    y = 20;

    editor = new GraffitiProperties (this);
}

Graffiti::~Graffiti ()
{
    delete editor;
}

Gtk::Widget *Graffiti::get_editor ()
{
    return editor->get_editor ();
}

bool Graffiti::load (xmlDocPtr doc,
		     xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    
    gchar *xml_val;

#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);
	    
	    xml_pos_set = true;
	}
	else
	    g_warning ("Error parsing `graffiti' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void Graffiti::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);
}

void Graffiti::save_rcp (ostream &ostr) const
{
    ostr << "  GRAFFITISTATEINDICATOR";
    ostr << " AT (" << x << " " << y << ")";
    ostr << endl;
}

GraffitiCanvasItem::GraffitiCanvasItem (Widgets::Graffiti *widget_,
					FormEditor::Form  *form_):
    CanvasItem (widget_),
    widget (widget_),
    form (form_),
    group (0)
{
    using namespace SigC;
    
    widget->changed.connect (slot (this, &GraffitiCanvasItem::update));
    update ();
}

void GraffitiCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)graffiti_canvas_xpm);
    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", pixbuf,
			   "x", (double)widget->get_x (),
			   "y", (double)widget->get_y (),
			   0);
    
    set_canvas_item (group);
}

CanvasItem* Graffiti::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new GraffitiCanvasItem (this, form);
}
