//$Id: button-prop.cc,v 1.7 2001/04/22 13:03:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"
#include "widgets/propertytable.h"
#include <gtk--/menu.h>

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

ButtonProperties::ButtonProperties (Button *res_):
    res (res_),
    update_block (false)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::Button::get_id),
	slot (res, &Widgets::Button::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Label */
    control = new GUI::Entry (
	true,
	slot (res, &Widgets::Button::get_text),
	slot (res, &Widgets::Button::set_text),
	res->changed);
    proptable->add (_("Text:"), *manage (control));

    /* Font */
    control = new GUI::NumEntry (
	0, 2,
	slot (res, &Widgets::Button::get_font),
	slot (res, &Widgets::Button::set_font),
	res->changed);
    proptable->add (_("Font:"), *manage (control));

    /* Frame type */
    frame_combo = new Gtk::OptionMenu ();
    /* Fill the frame type dropdown list */
    Menu *frame_menu = new Menu ();

#define FRAME_TYPE(s,t) \
	    frame_menu->items ().push_back ( \
		Menu_Helpers::MenuElem ( \
		    s, \
		    bind (slot (this, &ButtonProperties::frame_menu_cb), \
			  Widgets::t)));

    FRAME_TYPE (_("None"),   BUTTON_FRAME_NONE);
    FRAME_TYPE (_("Simple"), BUTTON_FRAME_SIMPLE);
    FRAME_TYPE (_("Bold"),   BUTTON_FRAME_BOLD);
    
#undef FRAME_TYPE

    frame_menu->show_all ();
    frame_combo->set_menu (*manage (frame_menu));
    proptable->add (_("Frame type:"), *manage (frame_combo));
    
    /* Repeat */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::Button::get_repeat),
	slot (res, &Widgets::Button::set_repeat),
	res->changed);
    proptable->add (_("Repeating:"), *manage (control));

    /* Usable */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::Button::get_usable),
	slot (res, &Widgets::Button::set_usable),
	res->changed);
    proptable->add (_("Usable:"), *manage (control));

    /* Anchor right */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::Button::get_anchor_right),
	slot (res, &Widgets::Button::set_anchor_right),
	res->changed);
    proptable->add (_("Anchor right:"), *manage (control));

    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Button::get_x),
	slot (res, &Widgets::Button::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Button::get_y),
	slot (res, &Widgets::Button::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control));

    /* Width */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Button::get_width),
	slot (res, &Widgets::Button::set_width),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::Button::get_manual_width),
	slot (res, &Widgets::Button::set_manual_width),
	res->changed);
    proptable->add (_("Width:"), *manage (control));

    /* Height */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Button::get_height),
	slot (res, &Widgets::Button::set_height),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::Button::get_manual_height),
	slot (res, &Widgets::Button::set_manual_height),
	res->changed);
    proptable->add (_("Height:"), *manage (control));
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));

    res->changed.connect (slot (this, &ButtonProperties::update));
}

ButtonProperties::~ButtonProperties ()
{
    property_editor->destroy ();
}

void ButtonProperties::update ()
{
    update_block = true;
    
    frame_combo->set_history (res->get_frame ());

    update_block = false;
}

Gtk::Widget* ButtonProperties::get_editor ()
{
    return property_editor;
}

void ButtonProperties::frame_menu_cb (Widgets::ButtonFrameType frame_type)
{
    res->set_frame (frame_type);
}
