//$Id: app-res.h,v 1.2 2001/03/11 14:14:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_APP_RES_H
#define GUIKATCHU_APP_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Application;
    }
}

#include <gnome-xml/tree.h>
#include <iostream>
#include <sigc++/basic_signal.h>
#include <string>

#include "app-win.h"
#include "resource.h"

namespace Guikachu
{
    namespace Resources
    {
	class Application
	{
	    GUI::AppWindow *gui;

	public:
	    Application ();
	    ~Application ();
	    SigC::Signal0<void> changed;

	    void show_ui ();

	    GUIKACHU_RESOURCE_PROP(iconname, string);
	    GUIKACHU_RESOURCE_PROP(version,  string);
	    GUIKACHU_RESOURCE_PROP(vendor,   string);
	    
	private:
	    bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    void save (xmlNodePtr node) const;
	    void save_rcp (ostream &ostr) const;
	    friend ostream& operator<< (ostream &ostr, const Application *res);

	    friend class ResourceManager;
	};

	ostream& operator<< (ostream &ostr, const Application* res);
    };
};

#endif /* !GUIKATCHU_APP_RES_H */
