//$Id: top-treeitem.cc,v 1.1 2001/03/03 14:10:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "top-treeitem.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "resource-manager.h"

using namespace Guikachu;

GUI::TopTreeItem::TopTreeItem (Resources::Application *res_):
    Gtk::TreeItem (_("Application")),
    res (res_)	 
{
    button_press_event.connect (slot (this, &GUI::TopTreeItem::clicked_cb));
    res->changed.connect (slot (this, &GUI::TopTreeItem::application_changed_cb));
}

int GUI::TopTreeItem::clicked_cb (GdkEventButton *e)
{
    if (e->type == GDK_2BUTTON_PRESS && e->button == 1)
	res->show_ui ();

    return false;
    
}

void GUI::TopTreeItem::application_changed_cb ()
{
    remove ();

    if (res->get_iconname () != "")
	add_label (res->get_iconname ());
    else
	add_label (_("Application"));
}
