//$Id: resource-combo.h,v 1.1 2001/03/09 17:11:21 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_COMBO_H
#define GUIKACHU_RESOURCE_COMBO_H

namespace Guikachu
{
    namespace GUI
    {
	class ResourceCombo;
    }
}

#include <gtk--/box.h>
#include <gtk--/combo.h>
#include <gtk--/button.h>
#include "resource.h"

namespace Guikachu
{
    namespace GUI
    {
	class ResourceCombo: public Gtk::HBox
	{
	    Gtk::Combo combo;
	    Gtk::Button button_edit;

	    Resources::Type type;
	    string current;
	    Resources::Resource *current_res;
	public:
	    ResourceCombo (Resources::Type type);
	    void set_value (const string& id);
	    SigC::Signal1<void, const string&> changed;
	private:
	    bool update_block;

	    void add_resource (Resources::Resource *res);
	    void remove_resource (Resources::Resource *res);
	    void resource_changed_cb (Resources::Resource *res);
	    
	    void edit_cb ();
	    void entry_cb ();
	};
    }
}

#endif /* !GUIKACHU_RESOURCE_COMBO_H */
