//$Id: form-res.h,v 1.4 2001/03/23 15:14:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_FORM_RES_H
#define GUIKATCHU_FORM_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Form;
    }
}

#include "resource.h"
#include "form-win.h"
#include "form-editor/widget.h"

#include <set>

namespace Guikachu
{
    namespace Resources
    {
	class Form: public Resource
	{
	    Guikachu::GUI::FormWindow *gui;

	    set<Widgets::Widget*> widgets;
	public:
	    Form (const string& name);
	    virtual ~Form ();
	    
	    virtual Type get_type () const { return RESOURCE_FORM; };
	    virtual void show_ui ();

	    GUIKACHU_RESOURCE_PROP(title,	string);
	    GUIKACHU_RESOURCE_PROP(help_id,	string);
	    GUIKACHU_RESOURCE_PROP(menu_id,	string);
	    GUIKACHU_RESOURCE_PROP(modal,	bool);
	    GUIKACHU_RESOURCE_PROP(frame,	bool);
	    GUIKACHU_RESOURCE_PROP(savebehind,	bool);
	    GUIKACHU_RESOURCE_PROP(x,		int);
	    GUIKACHU_RESOURCE_PROP(y,		int);
	    GUIKACHU_RESOURCE_PROP(width,	int);
	    GUIKACHU_RESOURCE_PROP(height,	int);

	    const set<Widgets::Widget*>& get_widgets () const { return widgets; };
	    
	    // Widget managment
	    Widgets::Widget* create_widget (Widgets::Type type,
					    const string& id);
	    Widgets::Widget* create_widget (Widgets::Type type);
	private:
	    // Persistance
	    virtual bool load (xmlDocPtr doc, xmlNodePtr node);
	    virtual void save (xmlNodePtr node) const;
	    virtual void save_rcp (ostream &ostr) const;

	    Widgets::Widget* load_widget (xmlDocPtr doc, xmlNodePtr node);
	};
    };
};

#endif /* !GUIKATCHU_FORM_RES_H */
