//$Id: form-res.cc,v 1.5 2001/03/23 15:14:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-res.h"

#include "form-editor/label.h"

using namespace Guikachu::Resources;

Form::Form (const string& id_)
{
    id = id_;

    modal = false;
    frame = true;
    savebehind = false;

    title = id;
    
    x = y = 0;
    width = height = 160;

    gui = new GUI::FormWindow (this);
}

Form::~Form ()
{
    for (set<Widgets::Widget*>::iterator i = widgets.begin ();
	 i != widgets.end (); i++)
    {
	ResourceManager::remove_resource ((*i)->get_id ());
	delete (*i);
	widgets.erase (i);
    }
    
    delete gui;
}

void Form::show_ui ()
{
    gui->show ();
}

Widgets::Widget* Form::create_widget (Widgets::Type type)
{
    string prefix;

    switch (type)
    {
    case Widgets::WIDGET_LABEL:
	prefix = "label";
	break;
    }
    
    return create_widget (type, ResourceManager::create_id (prefix));
}

Widgets::Widget* Form::create_widget (Widgets::Type type,
				      const string& id)
{
    if (!ResourceManager::register_resource (id))
	return 0;
	
    Widgets::Widget *res = 0;

    switch (type)
    {
    case Widgets::WIDGET_LABEL:
	res = new Widgets::Label (this, id);
	break;
    }
    
    widgets.insert (res);

#if 0
    res->changed.connect (SigC::slot (&ResourceManager::resource_changed_cb));
    dirty = true;
    
    resource_created (res);
#endif

    changed ();
    
    return res;
}
