//$Id: widget.h,v 1.3 2001/03/21 17:09:44 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_WIDGET_H
#define GUIKACHU_FORM_EDITOR_WIDGET_H

#include <string>
#include <iostream>
#include <gnome-xml/tree.h>
#include <sigc++/basic_signal.h>

namespace Guikachu
{
    namespace Resources
    {
	namespace Widgets
	{
	    enum Type
	    {
		WIDGET_LABEL
	    };
	    
	    class CanvasItem;
	    class Widget;
	}
    }
}

#include "form-res.h"
#include "form.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class CanvasItem
	    {
	    public:
		virtual ~CanvasItem () {};
	    };
	}
    }
    
    namespace Resources
    {
	namespace Widgets
	{
	    class Widget
	    {
	    protected:
		string id;
		Resources::Form *owner;
	    public:
		virtual ~Widget () {};
		
		virtual Type get_type () const = 0;
		
		// Resource managment functions
		string get_id () const;
		void   set_id (const string& id);
		
		SigC::Signal0<void> changed;
		
		virtual GUI::FormEditor::CanvasItem *get_canvas_item (GUI::FormEditor::Form *form) = 0;
		virtual Gtk::Widget *get_editor () = 0;
		
	    private:
		// Persistance
		virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node) = 0;
		virtual void save (xmlNodePtr node) const = 0;
		virtual void save_rcp (ostream &ostr) const = 0;
		friend ostream& operator<< (ostream &ostr, const Widget *res);
		
		friend class Resources::Form;
	    };
	    
	    ostream& operator<< (ostream &ostr, const Widget* res);
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_WIDGET_H */
