//$Id: label.cc,v 1.5 2001/03/26 22:19:27 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "form-editor.h"

#include <gnome--.h>

using Guikachu::Resources::Widgets::Label;
using namespace Guikachu::GUI::FormEditor;

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class LabelCanvasItem: public CanvasItem,
				   public SigC::Object
	    {
		Label              *res;
		Form               *form;
		Gnome::CanvasGroup *group;
	    public:
		LabelCanvasItem (Label *res,
				 Form  *form);
	    private:
		int LabelCanvasItem::canvas_event_cb (GdkEvent *e);
		void update ();
	    };
	}
    }
}

Label::Label (Form *owner_,
	      const string& id_):
    text (id_),
    font (0),
    x (5),
    y (20)
{
    id = id_;
    owner = owner_;

    editor = new LabelProperties (this);
}

Label::~Label ()
{
    delete editor;
}

Gtk::Widget *Label::get_editor ()
{
    return editor->get_editor ();
}

bool Label::load (xmlDocPtr doc,
		  xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_text_set = false;
    
    gchar *xml_val;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    g_free (xml_val); \
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    g_free (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "text") && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	    XML_GET_NUM_PROP (curr_node, "font", font);

	    xml_text_set = true;
	}
    }

    changed ();

    return true;
}

void Label::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Text and font */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*) text.c_str ());
    buffer = g_strdup_printf ("%d", font);
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);
}

void Label::save_rcp (ostream &ostr) const
{
    ostr << "  LABEL \"" << text << "\""
	 << " ID " << id
	 << " AT (" << x << " " << y << ")"
	 << " USABLE"
	 << " FONT " << font;
    ostr << endl;
}

LabelCanvasItem::LabelCanvasItem (Label *res_,
				  Form  *form_):
    res (res_),
    form (form_),
    group (0)
{
    using namespace SigC;
    
    res->changed.connect (slot (this, &LabelCanvasItem::update));
    update ();
}

int LabelCanvasItem::canvas_event_cb (GdkEvent *e)
{
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
	;
//	win->show_property_editor (get_editor ());
    
    return false;
}

void LabelCanvasItem::update ()
{
    using namespace SigC;
    
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    
    GdkFont *font = get_font (res->get_font ());
    
    Gnome::CanvasItem *item = new Gnome::CanvasText (*group,
						     "text", res->get_text ().c_str (),
						     "font_gdk", font,
						     "x", (float)res->get_x (),
						     "y", (float)res->get_y (),
						     "anchor", GTK_ANCHOR_NW,
						     "fill_color", GUIKACHU_FGC,
						     0);
    item->event.connect (slot (this, &LabelCanvasItem::canvas_event_cb));
    
    gdk_font_unref (font);
}

CanvasItem* Label::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new LabelCanvasItem (this, form);
}
