//$Id: label-prop.h,v 1.3 2001/03/26 20:57:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_LABEL_PROP_H
#define GUIKACHU_FORM_EDITOR_LABEL_PROP_H

#include <string>
#include <iostream>
#include <sigc++/object.h>
#include <glade/glade-xml.h>

#include <gtk--/entry.h>
#include <gtk--/spinbutton.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class LabelProperties;
	}
    }
}

#include "label.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class LabelProperties: public SigC::Object
	    {
		Resources::Widgets::Label *res;
		
		/* Property editor */
		GladeXML          *gui;
		Gtk::Widget       *property_editor;
		
		Gtk::Entry        *id_entry;
		Gtk::Entry        *text_entry;
		
		Gtk::SpinButton   *font_entry;
		Gtk::SpinButton   *x_entry, *y_entry;
		
	    public:
		LabelProperties (Resources::Widgets::Label *res);
		~LabelProperties ();
		Gtk::Widget *get_editor ();

	    private:
		void update ();
		bool update_block;
		
		void id_entry_cb (GdkEventFocus *e);
		void text_entry_cb ();
		
		void font_cb ();
		
		void x_cb ();
		void y_cb ();
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_LABEL_PROP_H */
