//$Id: label-prop.cc,v 1.3 2001/03/26 20:57:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label-prop.h"

#include <gnome--.h>
#include <sigc++/retbind.h>

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Resources::Widgets;

LabelProperties::LabelProperties (Label *res_):
    res (res_),
    update_block (false)
{
    using namespace Gtk;
    using namespace SigC;
    
    gui = glade_xml_new (GLADEDIR "/guikachu.glade", 0);
    property_editor = wrap (glade_xml_get_widget (gui, "widget_label"));
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
    property_editor->unparent ();

    id_entry =   wrap (GTK_ENTRY (glade_xml_get_widget (gui, "w_lbl_id")));
    text_entry = wrap (GTK_ENTRY (glade_xml_get_widget (gui, "w_lbl_text")));

    font_entry = wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_lbl_font")));
    
    x_entry = wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_lbl_x")));
    y_entry = wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_lbl_y")));

    id_entry->activate.connect (bind (
	slot (this, &LabelProperties::id_entry_cb), (GdkEventFocus*) 0));
    id_entry->focus_out_event.connect (retbind (
	slot (this, &LabelProperties::id_entry_cb), 0));
    
    text_entry->changed.connect (slot (this, &LabelProperties::text_entry_cb));

    font_entry->get_adjustment ()->value_changed.connect (slot (this, &LabelProperties::font_cb));

    x_entry->get_adjustment ()->value_changed.connect (slot (this, &LabelProperties::x_cb));
    y_entry->get_adjustment ()->value_changed.connect (slot (this, &LabelProperties::y_cb));

    res->changed.connect (slot (this, &LabelProperties::update));
    update ();
}

LabelProperties::~LabelProperties ()
{
    property_editor->destroy ();
    gtk_object_unref (GTK_OBJECT (gui));
}

void LabelProperties::update ()
{
    update_block = true;
    
    id_entry->set_text (res->get_id ());
    text_entry->set_text (res->get_text ());

    font_entry->set_value (res->get_font ());
    
    x_entry->set_value (res->get_x ());
    y_entry->set_value (res->get_y ());
    
    update_block = false;
}

Gtk::Widget* LabelProperties::get_editor ()
{
    return property_editor;
}

void LabelProperties::id_entry_cb (GdkEventFocus *e)
{
    res->set_id (id_entry->get_text ());
}

void LabelProperties::font_cb ()
{
    if (update_block)
	return;

    res->set_font (font_entry->get_value_as_int ());
}

void LabelProperties::x_cb ()
{
    if (!update_block)
	res->set_x (x_entry->get_value_as_int ());
}

void LabelProperties::y_cb ()
{
    if (!update_block)
	res->set_y (y_entry->get_value_as_int ());
}

void LabelProperties::text_entry_cb ()
{
    if (update_block)
	return;
    
    res->set_text (text_entry->get_text ());
}
