//$Id: form.cc,v 1.4 2001/03/21 17:09:44 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--.h>
#include <sigc++/retbind.h>

#include "form-editor.h"

using namespace Guikachu::GUI::FormEditor;

#define GUIKACHU_WINDOW_TITLE_HEIGHT 14

Form::Form (Resources::Form *res_,
	    GUI::FormWindow *win_):
    res (res_),
    win (win_),
    editor (res),
    canvas (win->get_canvas ()),
    group (0),
    frame_group (0),
    title_group (0),
    widget_group (0)
{
    using namespace SigC;
    
    new Gnome::CanvasRect ((*canvas->root ()),
			   "width_pixels", 0,
			   "x1",   0.0, "y1",   0.0,
			   "x2", 160.0, "y2", 160.0,
			   "fill_color", GUIKACHU_BGC,
			   NULL);

    group = new Gnome::CanvasGroup (*(canvas->root ()), 0, 0);
    group->event.connect (slot (this, &Form::canvas_event_cb));
    
    res->changed.connect (slot (this, &Form::update));
    update ();
}

Form::~Form ()
{
}

Gnome::CanvasGroup *Form::get_canvas () const
{
    return widget_group;
}

void Form::update ()
{
    draw_frame ();
    draw_title ();
    
    group->set_x (res->get_x ());
    group->set_y (res->get_y ());

    if (widget_group)
	delete widget_group;
    widget_group = new Gnome::CanvasGroup (*group, 0, 0);
    
    set<Resources::Widgets::Widget*> wset = res->get_widgets ();
    for (set<Resources::Widgets::Widget*>::iterator i = wset.begin ();
	 i != wset.end (); i++)
    {
	(*i)->get_canvas_item (this);
    }
}

Gtk::Widget* Form::get_editor ()
{
    return editor.get_editor ();
}

int Form::canvas_event_cb (GdkEvent *e)
{
    if ((e->type == GDK_BUTTON_PRESS) &&
	(e->button.button == 1))
	win->show_property_editor (get_editor ());
    
    
    return false;
}

void Form::draw_frame ()
{
    if (frame_group)
	delete frame_group;
    frame_group = new Gnome::CanvasGroup (*group, 0, 0);
    
    if (res->get_modal ())
	draw_frame_modal ();
    else
	if (res->get_frame ())
	    draw_frame_nonmodal ();
}

void Form::draw_frame_nonmodal ()
{
    new Gnome::CanvasRect (*frame_group,
			   "width_units", 1.0,
			   "x1", (double) -1,
			   "y1", (double) -1,
			   "x2", (double) res->get_width (),
			   "y2", (double) res->get_height (),
			   "outline_color", GUIKACHU_FGC,
			   "fill_color", 0,
			   0);
}

void Form::draw_frame_modal ()
{
    Gnome::CanvasPoints outer_points, inner_points;

    int x0 = 0;
    int y0 = 0;
    int x1 = res->get_width ();
    int y1 = res->get_height ();
    
    // NW
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 2) ));

    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y0 - 1) ));
    
    // NE
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 2) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y0)     ));

    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1),     (y0)     ));

    // SE
    outer_points.push_back (Gnome::Art::Point ( (x1 + 1), (y1 - 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1 + 1) ));

    inner_points.push_back (Gnome::Art::Point ( (x1),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x1 - 1), (y1)     ));

    // SW
    outer_points.push_back (Gnome::Art::Point ( (x0),     (y1 + 1) ));
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y1 - 1) ));
    
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0),     (y1 - 1) ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y1 - 1) ));
    
    outer_points.push_back (Gnome::Art::Point ( (x0 - 2), (y0)     ));
    inner_points.push_back (Gnome::Art::Point ( (x0 - 1), (y0)     ));
    
    new Gnome::CanvasLine (*frame_group,
			   "width_units", 1.0,
			   "points", outer_points.gtkobj (),
			   "fill_color", GUIKACHU_FGC,
			   0);

    new Gnome::CanvasLine (*frame_group,
			   "width_units", 1.0,
			   "points", inner_points.gtkobj (),
			   "fill_color", GUIKACHU_FGC,
			   0);
}

void Form::draw_title ()
{
    if (title_group)
	delete title_group;
    title_group = new Gnome::CanvasGroup (*group, 0, 0);

    if (res->get_title () == "")
	return;
    
    if (res->get_modal ())
	draw_title_modal ();
    else
	draw_title_nonmodal ();
}

void Form::draw_title_nonmodal ()
{
    Gnome::CanvasPoints points;
    double title_width;
    GdkFont *font;
    
    font = gdk_font_load (GUIKACHU_TITLE_FONT);
    
    title_width = gdk_string_width (font, res->get_title ().c_str ()) + 2;
    title_width = MIN (title_width + 5, res->get_width ());

    int max_width = res->get_width ();
    int max_height = MIN (res->get_height (), GUIKACHU_WINDOW_TITLE_HEIGHT);
    
    // NW corner
    points.push_back (Gnome::Art::Point (0, 1));
    points.push_back (Gnome::Art::Point (1, 0));

    // NE corner
    points.push_back (Gnome::Art::Point (title_width,     0));
    points.push_back (Gnome::Art::Point (title_width + 1, 1));

    // SE corner
    points.push_back (Gnome::Art::Point ((title_width + 1), (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // SW corner
    points.push_back (Gnome::Art::Point (0, (GUIKACHU_WINDOW_TITLE_HEIGHT + 1)));
    // Back to NW
    points.push_back (Gnome::Art::Point (0, 1));

    new Gnome::CanvasPolygon (*title_group,
			      "width_units", 1.0,
			      "points", points.gtkobj (),
			      "fill_color", GUIKACHU_FGC,
			      0);
    new Gnome::CanvasText (*title_group,
			   "text", res->get_title ().c_str (),
			   "font_gdk", font,
			   "x", 1.0, "y", 0.0,
			   "clip_width", (double) max_width,
			   "clip_height", (double) max_height,
			   "clip", TRUE,
			   "anchor", GTK_ANCHOR_NW,
			   "fill_color", GUIKACHU_BGC,
			   0);

    new Gnome::CanvasRect (*title_group,
			   "x1", (double)0,
			   "y1", (double)GUIKACHU_WINDOW_TITLE_HEIGHT,
			   "x2", (double)res->get_width (),
			   "y2", (double)(GUIKACHU_WINDOW_TITLE_HEIGHT + 1),
			   "width_units", 1.0,
			   "fill_color", GUIKACHU_FGC,
			   0);
    gdk_font_unref (font);
}

void Form::draw_title_modal ()
{
    Gnome::CanvasPoints points;
    GdkFont *font;
    
    font = gdk_font_load (GUIKACHU_TITLE_FONT);
    
    double title_height = MIN (res->get_height (), 11);
    double title_center = res->get_width () / 2;

    int max_width = res->get_width ();
    int max_height = MIN (res->get_height (), 11);
    
    new Gnome::CanvasRect (*title_group,
			   "width_units", 1.0,
			   "x1", (double)0,
			   "y1", (double)0,
			   "x2", (double)res->get_width (),
			   "y2", (double)title_height,
			   "fill_color", GUIKACHU_FGC,
			   0);
    new Gnome::CanvasText (*title_group,
			   "text", res->get_title ().c_str (),
			   "font_gdk", font,
			   "x", title_center,
			   "y", (double) - 1,
			   "clip_width", (double) max_width,
			   "clip_height", (double) max_height,
			   "clip", TRUE,
			   "anchor", GTK_ANCHOR_N,
			   "fill_color", GUIKACHU_BGC,
			   NULL);

    gdk_font_unref (font);
}
