//$Id: form-prop.cc,v 1.3 2001/03/26 20:57:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--.h>
#include <sigc++/retbind.h>

using namespace Guikachu::GUI::FormEditor;

FormProperties::FormProperties (Resources::Form *res_):
    res (res_),
    help_combo (Resources::RESOURCE_STRING),
    menu_combo (Resources::RESOURCE_MENU),
    update_block (false)
{
    using namespace Gtk;
    using namespace SigC;
    
    gui = glade_xml_new (GLADEDIR "/guikachu.glade", 0);
    property_editor = wrap (glade_xml_get_widget (gui, "widget_form"));
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
    property_editor->unparent ();
    
    id_entry = wrap (GTK_ENTRY (glade_xml_get_widget (gui, "w_frm_id")));
    title_entry = wrap (GTK_ENTRY (glade_xml_get_widget (gui, "w_frm_title")));

    x_entry =      wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_frm_x")));
    y_entry =      wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_frm_y")));
    width_entry =  wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_frm_width")));
    height_entry = wrap (GTK_SPIN_BUTTON (glade_xml_get_widget (gui, "w_frm_height")));

    Container *help_place = wrap (GTK_CONTAINER (glade_xml_get_widget (gui, "w_frm_help_place")));
    Container *menu_place = wrap (GTK_CONTAINER (glade_xml_get_widget (gui, "w_frm_menu_place")));

    modal = wrap (GTK_TOGGLE_BUTTON (glade_xml_get_widget (gui, "w_frm_modal")));
    frame = wrap (GTK_TOGGLE_BUTTON (glade_xml_get_widget (gui, "w_frm_frame")));
    savebg = wrap (GTK_TOGGLE_BUTTON (glade_xml_get_widget (gui, "w_frm_savebehind")));
    
    help_place->add (help_combo);
    menu_place->add (menu_combo);
    
    id_entry->activate.connect (bind (
	slot (this, &FormProperties::id_entry_cb), (GdkEventFocus*) 0));
    id_entry->focus_out_event.connect (retbind (
	slot (this, &FormProperties::id_entry_cb), 0));
	
    title_entry->changed.connect (slot (this, &FormProperties::title_entry_cb));

    x_entry->get_adjustment ()->value_changed.connect (slot (this, &FormProperties::x_cb));
    y_entry->get_adjustment ()->value_changed.connect (slot (this, &FormProperties::y_cb));
    width_entry->get_adjustment ()->value_changed.connect (slot (this, &FormProperties::w_cb));
    height_entry->get_adjustment ()->value_changed.connect (slot (this, &FormProperties::h_cb));

    modal->toggled.connect (bind (slot (this, &FormProperties::toggle_cb), modal));
    frame->toggled.connect (bind (slot (this, &FormProperties::toggle_cb), frame));
    savebg->toggled.connect (bind (slot (this, &FormProperties::toggle_cb), savebg));

    modal->clicked.connect (slot (this, &FormProperties::modal_cb));
    frame->clicked.connect (slot (this, &FormProperties::frame_cb));
    savebg->clicked.connect (slot (this, &FormProperties::savebg_cb));

    help_combo.changed.connect (slot (this, &FormProperties::help_combo_cb));
    menu_combo.changed.connect (slot (this, &FormProperties::menu_combo_cb));
    
    res->changed.connect (slot (this, &FormProperties::update));
    update ();
}

FormProperties::~FormProperties ()
{
    property_editor->destroy ();
    gtk_object_unref (GTK_OBJECT (gui));
}

void FormProperties::update ()
{
    update_block = true;

    id_entry->set_text (res->get_id ());
    title_entry->set_text (res->get_title ());

    help_combo.set_value (res->get_help_id ());
    menu_combo.set_value (res->get_menu_id ());
    
    x_entry->set_value (res->get_x ());
    y_entry->set_value (res->get_y ());
    width_entry->set_value (res->get_width ());
    height_entry->set_value (res->get_height ());

    frame->set_active (res->get_frame ());
    modal->set_active (res->get_modal ());
    savebg->set_active (res->get_savebehind ());
    
    update_block = false;
}

Gtk::Widget* FormProperties::get_editor ()
{
    return property_editor;
}

void FormProperties::id_entry_cb (GdkEventFocus *e)
{
    res->set_id (id_entry->get_text ());
}

void FormProperties::title_entry_cb ()
{
    if (!update_block)
	res->set_title (title_entry->get_text ());
}

void FormProperties::x_cb ()
{
    if (!update_block)
	res->set_x (x_entry->get_value_as_int ());
}

void FormProperties::y_cb ()
{
    if (!update_block)
	res->set_y (y_entry->get_value_as_int ());
}

void FormProperties::w_cb ()
{
    if (!update_block)
	res->set_width (width_entry->get_value_as_int ());
}

void FormProperties::h_cb ()
{
    if (!update_block)
	res->set_height (height_entry->get_value_as_int ());
}

void FormProperties::toggle_cb (Gtk::ToggleButton *btn)
{
    g_return_if_fail (btn != NULL);

    btn->remove ();
    Gtk::Label *lbl = new Gtk::Label;
    lbl->set_alignment (0.5, 0.5);
    
    if (btn->get_active ())
	lbl->set_text (_("Yes"));
    else
	lbl->set_text (_("No"));

    lbl->show ();
    btn->add (*manage (lbl));
}

void FormProperties::frame_cb ()
{
    if (!update_block)
	res->set_frame (frame->get_active ());
}

void FormProperties::modal_cb ()
{
    if (!update_block)
	res->set_modal (modal->get_active ());
}

void FormProperties::savebg_cb ()
{
    if (!update_block)
	res->set_savebehind (savebg->get_active ());
}

void FormProperties::help_combo_cb (const string& help_id)
{
    if (!update_block)
	res->set_help_id (help_id);
}

void FormProperties::menu_combo_cb (const string& menu_id)
{
    if (!update_block)
	res->set_menu_id (menu_id);
}
