//$Id: app-win.cc,v 1.1 2001/03/03 14:10:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <sigc++/retbind.h>

using namespace Guikachu;

GUI::AppWindow::AppWindow (Resources::Application *res_):
    res (res_)
{
    gui = glade_xml_new (GLADEDIR "/guikachu.glade", NULL);

    using namespace Gtk;
    using namespace SigC;
    
    window = Gtk::wrap (GTK_WINDOW (glade_xml_get_widget (gui, "res_application")));
    window->delete_event.connect (SigC::slot (this, &AppWindow::delete_event_impl));

    iconname_entry = wrap (GTK_ENTRY (glade_xml_get_widget (gui, "app_iconname")));
    version_entry =  wrap (GTK_ENTRY (glade_xml_get_widget (gui, "app_version")));
    vendor_entry =   wrap (GTK_ENTRY (glade_xml_get_widget (gui, "app_vendor")));
    
    iconname_entry->activate.connect
	(bind (slot (this, &AppWindow::iconname_entry_cb), (GdkEventFocus*) 0));
    iconname_entry->focus_out_event.connect
	(retbind (slot (this, &AppWindow::iconname_entry_cb), 0));

    version_entry->activate.connect
	(bind (slot (this, &AppWindow::version_entry_cb), (GdkEventFocus*) 0));
    version_entry->focus_out_event.connect
	(retbind (slot (this, &AppWindow::version_entry_cb), 0));

    vendor_entry->activate.connect
	(bind (slot (this, &AppWindow::vendor_entry_cb), (GdkEventFocus*) 0));
    vendor_entry->focus_out_event.connect
	(retbind (slot (this, &AppWindow::vendor_entry_cb), 0));
    
    res->changed.connect (slot (this, &AppWindow::update));
    update ();
}

GUI::AppWindow::~AppWindow ()
{
    window->destroy ();
    gtk_object_unref (GTK_OBJECT (gui));
}

int GUI::AppWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::AppWindow::show ()
{
    window->show_all ();
    window->get_window ().raise ();
}

void GUI::AppWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Application: %s"), res->get_iconname ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);

    iconname_entry->set_text (res->get_iconname ());
    version_entry->set_text (res->get_version ());
    vendor_entry->set_text (res->get_vendor ());
}

void GUI::AppWindow::iconname_entry_cb (GdkEventFocus *e)
{
    res->set_iconname (iconname_entry->get_text ());
}

void GUI::AppWindow::version_entry_cb (GdkEventFocus *e)
{
    res->set_version (version_entry->get_text ());
}

void GUI::AppWindow::vendor_entry_cb (GdkEventFocus *e)
{
    res->set_vendor (vendor_entry->get_text ());
}
