//$Id: app-res.cc,v 1.3 2001/03/09 17:11:21 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-res.h"

using namespace Guikachu;

Resources::Application::Application ()
{
    gui = new GUI::AppWindow (this);
}

Resources::Application::~Application ()
{
    delete gui;
}

void Resources::Application::show_ui ()
{
    gui->show ();
}

bool Resources::Application::load (xmlDocPtr doc,
				   xmlNodePtr node)
{
    xmlNodePtr curr_node;
    gchar *xml_iconname = 0;
    gchar *xml_version  = 0;
    gchar *xml_vendor   = 0;

    iconname = "";
    version = "";
    vendor = "";
    
    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (!strcmp ((char*)curr_node->name, "iconname") && !xml_iconname)
	    xml_iconname = (gchar*)xmlNodeListGetString (doc, curr_node->xmlChildrenNode, 1);
	else if (!strcmp ((char*)curr_node->name, "version") && !xml_version)
	    xml_version = (gchar*)xmlNodeListGetString (doc, curr_node->xmlChildrenNode, 1);
	else if (!strcmp ((char*)curr_node->name, "vendor") && !xml_vendor)
	    xml_vendor = (gchar*)xmlNodeListGetString (doc, curr_node->xmlChildrenNode, 1);
	else
	    g_warning ("Error parsing `application' resource: "
		       "unexpected element `%s'", curr_node->name);
    }

    if (xml_iconname)
    {
	iconname = xml_iconname;
	g_free (xml_iconname);
    }

    if (xml_version)
    {
	version = xml_version;
	g_free (xml_version);
    }
    
    changed ();
    return true;
}

void Resources::Application::save (xmlNodePtr node) const
{
    xmlNewChild (node, NULL, (xmlChar*)"iconname", (xmlChar*)iconname.c_str ());
    xmlNewChild (node, NULL, (xmlChar*)"version",  (xmlChar*)version.c_str ());
    xmlNewChild (node, NULL, (xmlChar*)"vendor",   (xmlChar*)vendor.c_str ());
}

void Resources::Application::save_rcp (ostream &ostr) const
{
    if (version != "")
	ostr << "VERSION ID 1 \"" << version << "\"" << endl;
    if (iconname != "")
	ostr << "APPLICATIONICONNAME ID 1 \"" << iconname << "\"" << endl;
    if (vendor != "")
	ostr << "APPLICATION ID 1 \"" << vendor << "\"" << endl;
    ostr << endl;
}

ostream& Resources::operator<< (ostream &ostr, const Application *res)
{
    res->save_rcp (ostr);
    return ostr;
}
