//$Id: string-res.h,v 1.2 2001/03/03 14:10:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_STRING_RES_H
#define GUIKATCHU_STRING_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class String;
    }
}

#include "resource.h"
#include "string-win.h"

namespace Guikachu
{
    namespace Resources
    {
	class String: public Resource
	{
	    string text;

	    GUI::StringWindow *gui;
	public:
	    String (const string& name_);
	    virtual ~String ();
	    
	    virtual Type get_type () const { return RESOURCE_STRING; };
	    virtual void show_ui ();

	    string get_text () { return text; };
	    void set_text (const string& text_) { text = text_; changed (); };

	private:
	    virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    virtual void save (xmlNodePtr node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    };
};

#endif /* !GUIKATCHU_STRING_RES_H */
