//$Id: app-res.h,v 1.1 2001/03/03 14:10:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_APP_RES_H
#define GUIKATCHU_APP_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Application;
    }
}

#include <gnome-xml/tree.h>
#include <iostream>
#include <sigc++/basic_signal.h>
#include <string>

#include "app-win.h"

namespace Guikachu
{
    namespace Resources
    {
	class Application
	{
	    string iconname;
	    string version;
	    string vendor;

	    GUI::AppWindow *gui;

	public:
	    Application ();
	    ~Application ();
	    SigC::Signal0<void> changed;

	    void show_ui ();
	    
	    string get_iconname () const { return iconname; };
	    void set_iconname (const string& iconname_) { iconname = iconname_; changed (); };

	    string get_version () const { return version; };
	    void set_version (const string& version_) { version = version_; changed (); };

	    string get_vendor () const { return vendor; };
	    void set_vendor (const string& vendor_) { vendor = vendor_; changed (); };
	    
	private:
	    bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    void save (xmlNodePtr node) const;
	    void save_rcp (ostream &ostr) const;
	    friend ostream& operator<< (ostream &ostr, const Application *res);

	    friend class ResourceManager;
	};

	ostream& operator<< (ostream &ostr, const Application* res);
    };
};

#endif /* !GUIKATCHU_APP_RES_H */
