<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="form/widgets/scrollbar/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:choose>
      <xsl:when test="@width='auto'">
	<xsl:text> 7</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> 7</xsl:text>
	<xsl:value-of select="@width"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@height"/>   
    <xsl:text>)</xsl:text>
    
  </xsl:template>
  
  <xsl:template match="form/widgets/scrollbar/values">
    <xsl:if test="@value">
      <xsl:text> VALUE </xsl:text>
      <xsl:value-of select="@value"/>
    </xsl:if>

    <xsl:if test="@min">
      <xsl:text> MIN </xsl:text>
      <xsl:value-of select="@min"/>
    </xsl:if>

    <xsl:if test="@max">
      <xsl:text> MAX </xsl:text>
      <xsl:value-of select="@max"/>
    </xsl:if>
    
    <xsl:if test="@page_size">
      <xsl:text> PAGESIZE </xsl:text>
      <xsl:value-of select="@page_size"/>
    </xsl:if>
    <xsl:text> </xsl:text>
  </xsl:template>
  
  <xsl:template match="form/widgets/scrollbar">

    <xsl:text>  SCROLLBAR</xsl:text>

    <xsl:text> ID </xsl:text>
    <xsl:value-of select="@id"/>

    <xsl:apply-templates select="pos"/>

    <xsl:choose>
      <xsl:when test="usable">
	<xsl:text> USABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> NONUSABLE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:apply-templates select="values"/>
    
    <xsl:text>
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
