//$Id: resource-manager.h,v 1.9 2001/10/28 14:08:47 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_MANAGER_H
#define GUIKACHU_RESOURCE_MANAGER_H

namespace Guikachu
{
    class ResourceManager;
}


#include "resource.h"
#include "app-res.h"
#include "string-case.h"
#include "storage-node.h"
#include <map>
#include <set>
#include <sigc++/signal_system.h>

namespace Guikachu
{
    class ResourceManager: public SigC::Object
    {
	static map<string_case, Resources::Resource*> resource_map;
	static set<string_case> id_set;
	static bool dirty;
	static Resources::Application *app;
    public:
	static Resources::Resource* create_resource (Resources::Type  type,
						     const string    &id = "");
	static void remove_resource (Resources::Resource *resource);
	static bool rename_resource (const string &old_id,
				     const string &new_id);

	static bool register_id   (const string &id);
	static void unregister_id (const string &id);

	static string create_id   (const string &prefix);
	static string validate_id (const string &id);

	static set<Resources::Resource*> get_resources ();
	static Resources::Resource* get_resource (const string &id);
	static Resources::Application* get_application () { return app; };
	
	// Signals
	static SigC::Signal1<void, Resources::Resource*> resource_created;
	static SigC::Signal1<void, Resources::Resource*> resource_removed;
	
	// Persistance
	static void reset ();
	static bool is_dirty ();
	static bool load (const string &filename);
	static void save (const string &filename);
	static void export_rcp (const string &filename); 

    private:
	static void resource_changed_cb ();
	static Resources::Resource* load_resource (StorageNode &node);
    };
}

#endif /* !GUIKACHU_RESOURCE_MANAGER_H */
