//$Id: text-field-canvas.cc,v 1.3 2001/10/26 20:46:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "text-field-canvas.h"
#include "form-editor.h"
#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-line.h>

using namespace Guikachu::GUI::FormEditor;

TextFieldCanvasItem::TextFieldCanvasItem (Widgets::TextField *widget_,
					  FormEditor::Form   *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void TextFieldCanvasItem::update ()
{   
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);

    const Font &font = get_font (widget->font);
    int height = widget->get_display_height ();
    int width = widget->get_display_width ();

    int line_height = font.get_height ();
    int num_lines = 1;
    if (height > line_height && widget->multi_line)
	num_lines = height / line_height;

    int x = widget->x;
    int y = widget->y + 1;
    
    /* Draw background */
    using Gnome::Art::Point;
    using namespace Gnome::CanvasHelpers;
    Gnome::CanvasPoints bg_points;
    
    bg_points.push_back (Point (x, y));
    bg_points.push_back (Point (x + width, y));
    bg_points.push_back (Point (x + width, y + height));
    bg_points.push_back (Point (x, y + height));
    
    new Gnome::CanvasPolygon (*group, bg_points);

    /* Draw underlines if enabled */
    if (widget->underline)
    {
	/* Data for the GdkBitmap to use as an outline stipple */
	static const char stipple_bits[] = {
	    0x01, };
	
	GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
							  stipple_bits,
							  2, 1);
	int underline_y = y + font.get_ascent ();
	for (int i = 0;
	     i < num_lines;
	     i++, underline_y +=  line_height)
	{
	    Gnome::CanvasPoints ul_points;
	    
	    ul_points.push_back (Point (x, underline_y));
	    ul_points.push_back (Point (x + width, underline_y));
	    
	    *(new Gnome::CanvasLine (*group, ul_points))
		<< fill_stipple (stipple)
		<< fill_color (widget->usable ? GUIKACHU_FGC : GUIKACHU_FGC_DISABLED);
	}

	gdk_bitmap_unref (stipple);
    }
    
    set_canvas_item (group);
}

void TextFieldCanvasItem::get_bounds (int &x1, int &y1,
				      int &x2, int &y2)
{
    x1 = widget->x;
    x2 = x1 + widget->get_display_width ();
    y1 = widget->y;
    y2 = y1 + widget->get_display_height ();
}
