//$Id: popup-trigger-prop.cc,v 1.6 2001/09/01 13:10:16 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widget-prop.h"
#include "resizeable-prop.h"
#include "textual-prop.h"

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"
#include "widgets/widget-combo.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

PopupTriggerProperties::PopupTriggerProperties (PopupTrigger *res)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Label */
    TextualProperties::add_controls (res, *proptable);

    /* Default button */
    control = new GUI::WidgetCombo (res->get_form (), Widgets::WIDGET_LIST, res->list_id);
    proptable->add (_("_List ID:"), *manage (control),
		    _("List to pup up upon activation"));
    
    /* Usable */
    control = new GUI::ToggleButton (res->usable);
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Anchor right */
    control = new GUI::ToggleButton (res->anchor_right);
    proptable->add (_("_Anchor right:"), *manage (control),
		    _("Keep right aligned when changing label "
		      "text at run-time"));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);
    
    /* Size */
    ResizeableProperties::add_controls (res, *proptable);
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

PopupTriggerProperties::~PopupTriggerProperties ()
{
    delete property_editor;
}

Gtk::Widget* PopupTriggerProperties::get_editor ()
{
    return property_editor;
}
