//$Id: dialog-win.h,v 1.9 2001/09/15 21:27:39 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_DIALOG_WIN_H
#define GUIKACHU_DIALOG_WIN_H

namespace Guikachu
{
    namespace GUI
    {
	class DialogWindow;
    }
}

#include "dialog-res.h"

#include <gtk--/window.h>
#include <gtk--/entry.h>
#include <gtk--/text.h>
#include <gtk--/optionmenu.h>
#include <gtk--/button.h>
#include <gtk--/list.h>
#include "widgets/resource-combo.h"

#include <glade/glade-xml.h>

namespace Guikachu
{
    namespace GUI
    {
	class DialogWindow: public SigC::Object
	{
	    Resources::Dialog   *res;
	    
	    GladeXML            *gui;
	    Gtk::Window         *window;
	    
	    Gtk::Entry          *id_entry;
	    Gtk::Entry          *title_entry;
	    Gtk::Text           *text_entry;
	    Gtk::OptionMenu     *type_combo;
	    GUI::ResourceCombo   help_combo;
	    
	    Gtk::List           *button_list;
	    Gtk::Button         *btnUp, *btnDown, *btnRemove, *btnAdd, *btnDefault;
	public:
	    DialogWindow (Resources::Dialog *res_);
	    ~DialogWindow ();
	    void show ();
	private:
	    int delete_event_impl (GdkEventAny *e);
	    void update ();

	    void id_entry_cb ();
	    void title_entry_cb ();
	    void text_entry_cb ();
	    void type_menu_cb (Resources::DialogType type);
	    bool update_block;

	    void button_add_cb ();
	    void button_remove_cb ();
	    void button_default_cb ();
	    void button_up_cb ();
	    void button_down_cb ();
	    void button_sel_change_cb ();

	    void dialog_add_cb (string name);
	};
    };
};

#endif /* !GUIKACHU_DIALOG_WIN_H */
