//$Id: string-win.cc,v 1.10 2001/08/31 16:11:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#ifdef USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "widgets/propertytable.h"
#include "widgets/entry.h"
#include "widgets/text.h"

using namespace Guikachu;

GUI::StringWindow::StringWindow (Guikachu::Resources::String *res_):
    res (res_),
    window (new Gtk::Window (GTK_WINDOW_DIALOG))
{
    using namespace SigC;

    window->delete_event.connect (slot (this, &StringWindow::delete_event_impl));
    window->set_policy (false, true, false);
    
#ifdef USE_WM_ICONS
    gnome_window_icon_set_from_file (window->gtkobj (), GNOME_ICONDIR "/guikachu.png");
#endif    

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;

    /* Resource ID */
    control = new GUI::Entry (false, res->id);
    proptable->add (_("Resource _ID:"), *manage (control));

    /* String contents */
    control = new GUI::TextArea (res->text);
    proptable->add (_("_String:"), *manage (control));
    
    window->add (*manage (proptable));
    
    res->changed.connect (slot (this, &StringWindow::update));
    update ();
}

GUI::StringWindow::~StringWindow ()
{
    delete window;
}

int GUI::StringWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::StringWindow::show ()
{
    window->show_all ();
    window->get_window ().raise ();
}

void GUI::StringWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("String: %s"), res->id ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);
}
