//$Id: form-win-helpers.h,v 1.2 2001/09/19 19:25:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_WIN_HELPERS_H
#define GUIKACHU_FORM_WIN_HELPERS_H

#include "form-win.h"

#include <gtk--/treeitem.h>
#include <gtk--/menu.h>
#include <gtk--/label.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormWindow_Helpers
	{
	    class WidgetTreeItem: public Gtk::TreeItem
	    {
		Widgets::Widget *widget;
		Gtk::Menu        popup_menu;
		Gtk::Label       label;
	    public:
		WidgetTreeItem (Widgets::Widget *widget);
		SigC::Signal0<void> activate;
	    private:
		void update ();
		void remove_cb ();
		int button_press_cb (GdkEventButton *e);
		void widget_selected_cb (bool selected);
	    };
	    
	    class TopTreeItem: public Gtk::TreeItem
	    {
		Resources::Form *res;
	    public:
		TopTreeItem (Resources::Form *res);
		SigC::Signal0<void> activate;
	    private:
		void update ();
		int button_press_cb (GdkEventButton *e);
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_WIN_HELPERS_H */
