//$Id: text-field.h,v 1.3 2001/10/23 13:05:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_TEXT_FIELD_H
#define GUIKACHU_FORM_EDITOR_TEXT_FIELD_H

namespace Guikachu
{
    namespace Widgets
    {
	class TextField;
    }
}

#include "widget.h"
#include "resizeable.h"

#include "text-field-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class TextField: public Widget,
			 public Resizeable
	{
	    GUI::FormEditor::TextFieldProperties *editor;
	    
	public:
	    TextField (Resources::Form *owner, const string& id);
	    virtual ~TextField ();
	    
	    virtual Type get_type () const { return WIDGET_TEXT_FIELD; };
	    
	    virtual GUI::FormEditor::CanvasItem *create_canvas_item (GUI::FormEditor::Form *form);
	    virtual Gtk::Widget                 *create_editor ();

	    Property<bool> usable;

	    Property<int>  font;
	    Property<bool> editable;
	    Property<bool> multi_line;
	    Property<bool> auto_shift;
	    Property<int>  max_length;
	    Property<bool> numeric;
	    
	    Property<bool> underline;
	    Property<bool> dynamic_size;
	    Property<bool> justify_right;
	    Property<bool> has_scrollbar;

	protected:
	    virtual int get_auto_width  ();
	    virtual int get_auto_height ();

	public:
	    virtual int get_display_height ();
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_TEXT_FIELD_H */
