//$Id: scrollbar-canvas.cc,v 1.8 2001/09/19 21:13:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "scrollbar-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-rect.h>
#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

ScrollBarCanvasItem::ScrollBarCanvasItem (Widgets::ScrollBar *widget_,
					  FormEditor::Form   *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void ScrollBarCanvasItem::update ()
{
    if (group)
	delete group;

    using namespace Gnome::CanvasHelpers;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);

    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    int x1 = widget->x;
    int x2 = x1 + width;
    int y1 = widget->y;
    int y2 = y1 + height;


    // Step 1: the arrows
    int arrow_width  = width;
    int arrow_height = (arrow_width + 1) / 2;
    int arrow_left = x1 + 1;
    int arrow_middle = x1 + 1 + arrow_width / 2;
    int arrow_right = x1 + arrow_width;
    using Gnome::Art::Point;

    Gnome::CanvasPoints up_arrow_points;
    up_arrow_points.push_back (Point (arrow_left,   y1 + 1 + arrow_height));
    up_arrow_points.push_back (Point (arrow_middle, y1 + 1));
    up_arrow_points.push_back (Point (arrow_right,  y1 + 1 + arrow_height));
    *(new Gnome::CanvasPolygon (*group, up_arrow_points))
	<< fill_color (GUIKACHU_FGC);

    Gnome::CanvasPoints dn_arrow_points;
    dn_arrow_points.push_back (Point (arrow_left,   y2 - arrow_height));
    dn_arrow_points.push_back (Point (arrow_middle, y2));
    dn_arrow_points.push_back (Point (arrow_right,  y2 - arrow_height));
    *(new Gnome::CanvasPolygon (*group, dn_arrow_points))
	<< fill_color (GUIKACHU_FGC);

    // Step 2: the scrolling range

    /* FIXME: the scrolling range should have a minimum width of 1 */
    int range_height = height - 2 * (arrow_height + 2);
    int range_x1 = x1 + 3;
    int range_x2 = x2 - 2;
    int range_y1 = y1 + arrow_height + 2;
    int range_y2 = range_y1 + range_height;
    
    /* Data for the GdkBitmap to use as a fill stipple */
    char stipple_bits[] = { 0x01, 0x02 };

    Gnome::CanvasRect *scroll_range =
	new Gnome::CanvasRect (*group,
			       range_x1, range_y1,
			       range_x2, range_y2);
    
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      2, 2);    
    scroll_range->set_fill_stipple (stipple);
    gdk_bitmap_unref (stipple);

    if (widget->usable)
	scroll_range->set_fill_color (GUIKACHU_FGC);
    else
	scroll_range->set_fill_color (GUIKACHU_FGC_DISABLED);


    // Step 3: The value marker

    int value_range_size = widget->max_value - widget->min_value;

    int slider_size = 10;
    if (widget->page_size)
    {
	double page_ratio = (double) value_range_size / (double) widget->page_size;
	double page_size = 1.0 / (page_ratio + 1.0) * range_height;

	if (page_size > 10)
	    slider_size = (int) page_size;
    }
    
    int slider_y = 0;
    if (value_range_size)
    {
	int value_abs = widget->value - widget->min_value;
	double value_ratio = (double)value_abs / (double)value_range_size;

	if (value_ratio < 0)
	    value_ratio = 0;
	
	if (value_ratio > 1)
	    value_ratio = 1;

	slider_y = (int) (value_ratio * (range_height - slider_size));
    }
    
    int slider_top = range_y1 + slider_y;
    int slider_bottom = slider_top + slider_size;
    
    // Space around the mark

    *(new Gnome::CanvasRect (*group,
			     range_x1, slider_top - 1,
			     range_x2, slider_bottom + 1))
	<< fill_color (GUIKACHU_BGC);

    // The mark itself
    *(new Gnome::CanvasRect (*group,
			     range_x1, slider_top,
			     range_x2, slider_bottom))
	<< fill_color (widget->usable ? GUIKACHU_FGC : GUIKACHU_FGC_DISABLED);

    set_canvas_item (group);
}
