//$Id: popup-trigger-canvas.cc,v 1.7 2001/10/20 16:06:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-rect.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/popup-trigger-canvas.xpm"
#include "pixmaps/popup-trigger-canvas-disabled.xpm"

using namespace Guikachu::GUI::FormEditor;

PopupTriggerCanvasItem::PopupTriggerCanvasItem (Widgets::PopupTrigger *widget_,
						FormEditor::Form      *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void PopupTriggerCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);

    GdkPixbuf *pixbuf = 0;
    if (widget->usable)
	pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)popup_trigger_canvas_xpm);
    else
	pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)popup_trigger_canvas_disabled_xpm);

    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", pixbuf,
			   "x", (double)widget->x,
			   "y", (double)widget->y,
			   0);
    gdk_pixbuf_unref (pixbuf);
    
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    int text_x = widget->x + 15;
    int text_y = widget->y;

    draw_text (*group,
	       widget->text, widget->font,
	       text_x, text_y,
	       widget->usable,
	       GTK_ANCHOR_NW,
	       width, height);

    set_canvas_item (group);
}

void PopupTriggerCanvasItem::get_bounds (int &x1, int &y1,
					 int &x2, int &y2)
{
    x1 = widget->x;
    x2 = x1 + widget->get_display_width () + 15 + 2;
    y1 = widget->y - 1;
    y2 = y1 + widget->get_display_height () +2;
}
