//$Id: list.cc,v 1.12 2001/10/09 16:37:13 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list.h"
#include "list-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::List;
using namespace Guikachu::GUI::FormEditor;

List::List (Resources::Form *owner,
	    const string& id):
    Widget (owner, id),
    editor (0),
    font (changed, 0),
    visible_items (changed, 4),
    usable (changed, true),
    items (changed, vector<string> ()),
    width (changed, 1),
    manual_width (changed, false)
{
}

List::~List ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *List::create_editor ()
{
    if (!editor)
	editor = new ListProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* List::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new ListCanvasItem (this, form);
}

bool List::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");

	    string width_str = curr_node.get_prop<string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "items")
	{
	    curr_node.set_prop ("font", font);
	    curr_node.set_prop ("visible", visible_items);
	    
	    /* Iterate items */
	    vector<string> items_vec;
	    
	    for (StorageNode item_node = curr_node.children ();
		 item_node; item_node++)
	    {
		if (item_node.name () == "item")
		    items_vec.push_back (item_node.get_content ());
		else
		    g_warning ("Error parsing `list' resource: "
			       "unexpected element `%s/%s'",
			       curr_node.name ().c_str (),
			       item_node.name ().c_str ());
	    }
	    
	    items = items_vec;
	}
	else
	    g_warning ("Error parsing `list' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();
    
    return true;
}

void List::save (StorageNode &node) const
{
    StorageNode my_node;
    
    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    /* Usable */
    if (usable)
	node.add_node ("usable");

    /* List items */
    my_node = node.add_node ("items");
    my_node.set_prop ("font", font);
    my_node.set_prop ("visible", visible_items);
    
    const vector<string> &items_vec = items;
    for (vector<string>::const_iterator i = items_vec.begin ();
	 i != items_vec.end (); i++)
	my_node.add_node ("item", *i);
}

void List::save_rcp (ostream &ostr) const
{
    gchar *width_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("AUTO");
    
    ostr << "  LIST";
    const vector<string> &items_vec = items;
    for (vector<string>::const_iterator i = items_vec.begin ();
	 i != items_vec.end (); i++)
	ostr << " \"" << *i << "\"";
    
    ostr << " ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << " AUTO)";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";

    ostr << " VISIBLEITEMS " << visible_items;
    
    ostr << endl;

    g_free (width_str);
}
