//$Id: gadget-prop.cc,v 1.2 2001/10/22 17:38:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gadget-prop.h"


#include "config.h"
#include <libgnome/libgnome.h>

#include "widget-prop.h"

#include "widgets/propertytable.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

GadgetProperties::GadgetProperties (Gadget *res)
{
    using namespace Gtk;
    using namespace SigC;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Usable */
    control = new GUI::ToggleButton (res->usable);
    proptable->add (_("_Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);

    /* Size */
    control = new GUI::SizeEntry (res->width);
    proptable->add (_("_Width:"), *manage (control),
		    _("Horizontal size of the widget"));
    
    control = new GUI::SizeEntry (res->height);
    proptable->add (_("_Height:"), *manage (control),
		    _("Vertical size of the widget"));
    
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

GadgetProperties::~GadgetProperties ()
{
    delete property_editor;
}

Gtk::Widget* GadgetProperties::get_editor ()
{
    return property_editor;
}
