//$Id: gadget-canvas.cc,v 1.1 2001/10/19 11:14:33 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gadget-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

GadgetCanvasItem::GadgetCanvasItem (Widgets::Gadget *widget_,
					FormEditor::Form  *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void GadgetCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);    

    int x1 = widget->x;
    int x2 = x1 + widget->width;
    int y1 = widget->y;
    int y2 = y1 + widget->height;
    
    static const char stipple_bits[] = {
	0x04, 0x02, 0x01, };
    
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      3, 3);
    
    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    Gnome::CanvasPoints frame_points;
    using namespace Gnome::Art;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    using namespace Gnome::CanvasHelpers;
    *(new Gnome::CanvasPolygon (*group, frame_points))
	<< fill_stipple (stipple)
	<< fill_color (widget->usable ? GUIKACHU_FGC : GUIKACHU_FGC_DISABLED);

    gdk_bitmap_unref (stipple);

    set_canvas_item (group);
}
