//$Id: blob-res.h,v 1.1 2001/10/19 20:17:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_BLOB_RES_H
#define GUIKACHU_BLOB_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Blob;
    }
}

#include "resource.h"
#include "blob-win.h"

namespace Guikachu
{
    namespace Resources
    {
	class Blob: public Resource
	{
	    GUI::BlobWindow *gui;
	public:
	    Blob (const string& id);
	    virtual ~Blob ();

	    virtual Type get_type () const { return RESOURCE_BLOB; };
	    virtual void show_ui ();

	    Property<string> contents;

	private:
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    };
};

#endif /* !GUIKACHU_BLOB_RES_H */
